info() {
	[ "${debug:-2}" -lt 2 ] && return
	printf "%s\n" "$@"
}

warning() {
	[ "${debug:-2}" -lt 1 ] && return
	printf "WARNING: %s\n" "$@" >&2
}

ERRORS=""
soft_error() {
	warning "$@"
	ERRORS="$ERRORS
$*"
}

reset_password() {
    info "reset root password"
    echo "abos-web-admin:!" | chpasswd -e || soft_error "Failed to reset abos-web-admin password"
    passwd -de root || soft_error "Failed to reset root password"
    persist_file /etc/shadow  || soft_error "Failed to persist password"
}

reset_modem() {
    info "reset modem settings"
    wwan-clean-reset || soft_error "Failed to reset modem settings"
}

reset_network_settings() {
    info "reset network settings"
    # Create bridge interface with INTERFACE="eth0"
    local bridge_name="abos_web_br_ap"
    local bridge_if="br_ap"
    local abos_web_br_ap_con="/etc/NetworkManager/system-connections/$bridge_name.nmconnection"
    cat > "$abos_web_br_ap_con" <<EOF
[connection]
id=$bridge_name
uuid=14aeeaee-6844-400d-b3bd-a985a2cae40a
type=bridge
interface-name=$bridge_if

[ethernet]

[bridge]
stp=false

[ipv4]
address1=192.168.100.1/24
method=manual

[ipv6]
addr-gen-mode=default
method=auto

[proxy]
EOF
    chmod 600 "$abos_web_br_ap_con" || soft_error "Failed to chmod $abos_web_br_ap_con"

    local slave_name="abos_web_slave_ap"
    local abos_web_slave_ap_con="/etc/NetworkManager/system-connections/$slave_name.nmconnection"
    cat > "$abos_web_slave_ap_con" <<EOF
[connection]
id=$slave_name
uuid=a3e57dc8-3ced-4518-96fa-1b5502d09b1b
type=ethernet
controller=14aeeaee-6844-400d-b3bd-a985a2cae40a
interface-name=eth0
port-type=bridge

[ethernet]

[bridge-port]
EOF
    chmod 600 "$abos_web_slave_ap_con" || soft_error "Failed to chmod $abos_web_slave_ap_con"

    # Configure DHCP settings
    local dhcp_conf="/etc/dnsmasq.d/abos_web_dhcp_$bridge_if.conf"
    local addr_range_start="192.168.100.100"
    local addr_range_end="192.168.100.254"
    local lease_time="24h"
    cat > "$dhcp_conf" <<EOF
interface=$bridge_if
bind-dynamic
dhcp-range=tag:$bridge_if, $addr_range_start, $addr_range_end, $lease_time
EOF

    # Configure iptables settings
    local sysctl_conf="/etc/sysctl.d/abos_web_ipforward.conf"
    echo "net.ipv4.ip_forward = 1" > "$sysctl_conf"

    local iptables_rules_save="/etc/iptables/rules-save"
    cat > "$iptables_rules_save" <<EOF
*filter
:INPUT ACCEPT [0:0]
:FORWARD ACCEPT [0:0]
:OUTPUT ACCEPT [0:0]
COMMIT
*nat
:PREROUTING ACCEPT [0:0]
:INPUT ACCEPT [0:0]
:OUTPUT ACCEPT [0:0]
:POSTROUTING ACCEPT [0:0]
[0:0] -A POSTROUTING -o ppp0 -m comment --comment abos-web-nat -j MASQUERADE
COMMIT
EOF

    persist_file "$iptables_rules_save" \
        "$abos_web_br_ap_con" \
        "$abos_web_slave_ap_con" \
        "$dhcp_conf" \
        "$sysctl_conf" || soft_error "Failed to persist network settings"
}

remove_files() {
    info "remove files"
    persist_file -df "/etc/atmark/power-utils.conf"

    ROLLBACK_VOLUMES_GW="/var/app/rollback/volumes/gw_container"
    rm -rf $ROLLBACK_VOLUMES_GW/config/sensing_mgr.conf \
        $ROLLBACK_VOLUMES_GW/config/cloud_agent.conf \
        $ROLLBACK_VOLUMES_GW/src/customize/*
}

custom_commands() {
    reset_password
    reset_modem
    reset_network_settings
    remove_files
}

dryrun_custom_commands() {
    info "Resetting password..."
    info "Resetting modem..."
    info "Resetting network settings..."
    info "Removing files..."
}

# Be loud when the feature is used (so reseting through button is obvious)
custom_early_commands() {
	echo "Reset default running! Will reboot after reset" > /dev/console 2>/dev/null
	[ -e /sys/class/leds/sys ] || return
	cd /sys/class/leds/sys
	echo timer > trigger
	echo 150 | tee delay_on > delay_off
}
