//
// pwu_config.h
//

#ifndef PWU_CONFIG_H
#define PWU_CONFIG_H

#include <stddef.h>


#if defined __cplusplus
extern "C" {
#endif  // __cplusplus

typedef void*	pwu_config_t;

typedef enum PWU_MODE {
	PWU_MODE_UNKNOWN,
	PWU_MODE_NONE,
	PWU_MODE_SHUTDOWN,
	PWU_MODE_SLEEP,
} PWU_MODE;

typedef enum PWU_WAKEUP {
	PWU_WAKEUP_UNKNOWN,
	PWU_WAKEUP_AIN,
	PWU_WAKEUP_RTC,
	PWU_WAKEUP_SW1,
	PWU_WAKEUP_GPIO,
	PWU_WAKEUP_USB,
	PWU_WAKEUP_UART,
	PWU_WAKEUP_SMS,
} PWU_WAKEUP;

extern int	pwu_config_load(const char* conf_file, pwu_config_t* outConf);
extern void	pwu_config_dispose(pwu_config_t conf);

extern const char*	pwu_config_target_container(pwu_config_t conf);
extern PWU_MODE	pwu_config_mode(pwu_config_t conf);
extern PWU_WAKEUP	pwu_config_wakeup(pwu_config_t conf, const void** outParam);

extern size_t	pwu_config_count_targets(pwu_config_t conf);
extern const char* pwu_config_target_at(pwu_config_t conf, size_t index);

extern size_t	pwu_config_count_wakeups(pwu_config_t conf);
extern PWU_WAKEUP	pwu_config_wakeup_at(pwu_config_t conf, size_t index, const void** outParam);
extern int	pwu_config_get_wakeup_param(pwu_config_t conf, PWU_WAKEUP wakeup, const void** outParam);

#if defined __cplusplus
}
#endif  // __cplusplus

#endif  // PWU_CONFIG_H

//
// End of File
//
