//
// power_state_handler.h
//
#include <stdbool.h>

typedef void* power_state_handler_t;

typedef enum {
	POWER_NORMAL,
	POWER_SLEEP_DISABLED,
	POWER_SLEEP_INHIBITED,
	POWER_PRE_SLEEP,
	POWER_SLEEPING,
} EPowerHandlerState;

#define SERVICE_NAME	"atmark-power-svc"
#define REQ_POWER_STATE_NOTIFICATION	"request_power_state_notificaiton"

extern power_state_handler_t	PowerStateHandler_Create();
extern void	PowerStateHandler_Destroy(power_state_handler_t handler);

extern bool	PowerStateHandler_Start(power_state_handler_t handler);
extern void	PowerStateHandler_Stop(power_state_handler_t handler);
extern bool	PowerStateHandler_IsRunnig(power_state_handler_t handler);
extern EPowerHandlerState	PowerStateHandler_CurrentState(
	power_state_handler_t handler);

extern bool	Request_PowerStateHandler_StartInhibitSleep();
extern bool	Request_PowerStateHandler_FinishInhibitSleep();
extern bool	Request_PowerStateHandler_StartSleep();
extern bool	Notify_PowerStateHandler_FinishSleep();
extern bool	Request_PowerStateHandler_DisableSleep();
extern bool	Request_PowerStateHandler_EnableSleep();

//
// End of File
//
