//
// un_socket.c
//

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/un.h>

#include "un_socket.h"


#define SERVER_ADDR	"atmark-power-utils"

#define UNSOCK_ADDR_LEN(un_sock, addr) \
	(sizeof(un_sock.sun_family) + 1 + strlen(addr))

static int
make_unsock(struct sockaddr_un* unsock_addr, const char* name)
{
	int	sockfd = socket(AF_LOCAL, SOCK_DGRAM|SOCK_CLOEXEC, 0);

	if (sockfd < 0) {
		printf("failed to socket().\n");
		return -1;
	}
	bzero(unsock_addr, sizeof(*unsock_addr));
	unsock_addr->sun_family = AF_LOCAL;
	strcpy((char*)unsock_addr->sun_path + 1, name);  // prefix the name with '\0'

	return sockfd;
}


int
create_server_socket()
{
	int	sockfd;
	struct sockaddr_un	serv_addr;

	sockfd = make_unsock(&serv_addr, SERVER_ADDR);
	if (sockfd < 0) {
		return -1;
	} else if (0 != bind(sockfd, (struct sockaddr*)&serv_addr,
			UNSOCK_ADDR_LEN(serv_addr, SERVER_ADDR))) {
		close(sockfd);
		printf("failed to bind().\n");
		return -1;
	}

	return sockfd;
}

int
create_client_socket()
{
	int	sockfd;
	struct sockaddr_un	serv_addr;

	sockfd = make_unsock(&serv_addr, SERVER_ADDR);
	if (sockfd < 0) {
		return -1;
	} else if (0 != connect(sockfd, (struct sockaddr*)&serv_addr,
			UNSOCK_ADDR_LEN(serv_addr, SERVER_ADDR))) {
		close(sockfd);
		printf("failed to connect().\n");
		return -1;
	}

	return sockfd;
}

void
dispose_socket(int sockfd)
{
	(void)close(sockfd);
}

size_t
sock_send(int sockfd, const unsigned char* data, size_t len)
{
	return ((size_t)send(sockfd, data, len, 0) == len ? 0 : -1);
}

size_t
sock_recv(int sockfd, unsigned char* buf, size_t len)
{
	struct sockaddr_un	cli_addr;
	socklen_t	addr_len = sizeof(cli_addr);
	ssize_t	recv_len;

	recv_len = recvfrom(sockfd, buf, len, 0, (struct sockaddr*)&cli_addr, &addr_len);
	return recv_len;
}

//
// End of File
//
