//
// power_funcs.c
//

#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>

#include "power_funcs.h"


#define AIOT_WAKE_TRIGGER	"/usr/bin/aiot-set-wake-trigger"
#define AIOT_POWEROFF	"/usr/bin/aiot-alarm-poweroff"
#define AIOT_SLEEP	"/usr/bin/aiot-sleep"


static int	sWakeBySMS = 0;


static int
set_wake_trigger(const char* dev, bool enable)
{
	char	cmd[256];

	sprintf(cmd, "%s %s %s", AIOT_WAKE_TRIGGER, dev, (enable ? "enabled" : "disabled"));
	if (system(cmd) != 0) {
		fprintf(stderr, "%s failed for %s.\n", AIOT_WAKE_TRIGGER, dev);
		return -1;
	}

	return 0;
}

static int
enable_rtc_wake_trigger(unsigned long secs)
{
	char	cmd[256];

	sprintf(cmd, "%s rtc enabled +%lu", AIOT_WAKE_TRIGGER, secs);
	if (system(cmd) != 0) {
		fprintf(stderr, "%s failed for rtc.\n", AIOT_WAKE_TRIGGER);
		return -1;
	}

	return 0;
}

int
power_shutdown(unsigned long poweroff_secs)
{
	char	cmd[256];

	if (poweroff_secs < 180) {
		fprintf(stderr, "invalid argument for %s\n", __FUNCTION__);
		return -1;
	}
	sprintf(cmd, "%s +%lu", AIOT_POWEROFF, poweroff_secs);
	(void)system(cmd);

	return 0;
}

int
power_enable_wakeup_causes(pwu_config_t conf)
{
	int	sts = 0;

	sWakeBySMS = 0;  // reset
	for (size_t i = 0, n = pwu_config_count_wakeups(conf); i < n; ++i) {
		const void* param;
		PWU_WAKEUP	wakeup = pwu_config_wakeup_at(conf, i, &param);

		switch (wakeup) {
		case PWU_WAKEUP_RTC:
			if ((sts = enable_rtc_wake_trigger((unsigned long)param)) != 0) {
				goto err;
			}
			break;
		case PWU_WAKEUP_AIN:
			if ((sts = set_wake_trigger("ain", true))) {
				goto err;
			}
			break;
		case PWU_WAKEUP_SW1:
			if ((sts = set_wake_trigger("sw1", true))) {
				goto err;
			}
			break;
		case PWU_WAKEUP_GPIO:
			if ((sts = set_wake_trigger("gpio", true))) {
				goto err;
			}
			break;
		case PWU_WAKEUP_USB:
			if ((sts = set_wake_trigger("usb", true))) {
				goto err;
			}
			break;
		case PWU_WAKEUP_UART:
			if ((sts = set_wake_trigger("uart", true))) {
					goto err;
			}
			break;
		case PWU_WAKEUP_SMS:
			sWakeBySMS = 1;
			break;
		case PWU_WAKEUP_UNKNOWN:
			break;
		}
	}

	return 0;
err:
	return sts;
}

int
power_enable_wakeup_by_snvs_rtc(unsigned long secs)
{
	char	cmd[256];

	sprintf(cmd, "%s rtc_sec enabled +%lu", AIOT_WAKE_TRIGGER, secs);
	if (system(cmd) != 0) {
		fprintf(stderr, "%s failed for rtc_sec.\n", AIOT_WAKE_TRIGGER);
		return -1;
	}

	return 0;
}

int
power_disable_wakeup_all()
{
	(void)set_wake_trigger("all", false);
	(void)set_wake_trigger("sw1", false);
	return 0;
}

int
power_suspend()
{
	char	cmd[256];

	sprintf(cmd, "%s%s", AIOT_SLEEP, (sWakeBySMS ? " sms" : ""));
	(void)system(cmd);

	return 0;
}

//
// End of File
//
