import setuptools

setuptools.setup(
    name="atgateway",
    version="2.7.0",
    author="Atmark Techno, Inc.",
    author_email="reika.yamazaki@atmark-techno.com",
    description="AtmarkTechno Gateway Container App",
    py_modules=['atgateway'],
    packages=setuptools.find_packages(),
    data_files=[
        ('/etc/atgateway', [
            'config/sensing_mgr.conf',
            'config/cloud_agent.conf',
        ])
    ],
    classifiers=[
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.12",
    ],
    python_requires='>=3.12',
    install_requires=[
        'libevdev',
        'wheel',
        'requests',
        'awsiotsdk',
        'azure-iot-device',
        'pymodbus==3.4.1',
        'gpiod==1.5.4',
    ],
    scripts=['bin/gw-app.sh'],
)
