import fcntl
import os
import select

import libevdev

from ..modules.lib.report import Report
from ..modules.lib.active_reporter import ActiveReporter


class SwEventReporter(ActiveReporter):
    def __init__(self, report_queue, report_repository, sw_dev):
        super().__init__(report_queue, report_repository)
        self._wait_event = os.eventfd(0, os.EFD_CLOEXEC)
        self._sw_dev = sw_dev

    def data_type(self):
        return 'sw_event'

    def request_stop(self):
        super().request_stop()
        os.eventfd_write(self._wait_event, 1)

    def _before_loop(self):
        return

    def _after_loop(self):
        return

    def _do_transit_action(self, next_state):
        return

    def _handle_state(self):
        with open(self._sw_dev, "rb") as fd:
            fcntl.fcntl(fd, fcntl.F_SETFL, os.O_NONBLOCK)
            dev = libevdev.Device(fd)
            fired = select.select([fd, self._wait_event], [], [], 10.0)
            if fired[0]:
                for rfd in fired[0]:
                    if rfd == self._wait_event:
                        os.eventfd_read(rfd)
                        print("stop requested, finish the loop...")
                        break
                    elif rfd == fd:
                        for ev in dev.events():
                            if not ev.matches(libevdev.EV_KEY):
                                continue
                            if ev.value == 1:
                                # report that SW1 pressed
                                print("SW1 pressed.")
                                report = Report.report_now(
                                    'measurement',
                                    sw_state=1
                                )
                                self._report_queue.push(report)
                                pass
                            elif ev.value == 0:
                                # report that SW1 released
                                print("SW1 released.")
                                report = Report.report_now(
                                    'measurement',
                                    sw_state=0
                                )
                                self._report_queue.push(report)
                                pass

#
# End of File
#
