from ..modules.lib.reporter import Reporter
from ..modules.lib.report import Report


class RS485Reporter(Reporter):
    def __init__(self, start, rs485_mgr, method, data_num, baudrate,
                 device_id, data_size, stop_bits, parity,
                 reg_addr, func_code, count, endian,
                 data_offset, data_multiply, data_divider):
        super().__init__(start)
        self._rs485_mgr = rs485_mgr
        if start is True:
            rs485_mgr.create_new_connection(
                method, baudrate, device_id, data_size, stop_bits, parity)
        self._device_id = device_id
        self._data_num = data_num
        self._reg_addr = reg_addr
        self._func_code = func_code
        self._count = count
        self._endian_isBig = self.check_endian_isBig(endian)
        self._data_offset = data_offset
        self._data_multiply = data_multiply
        self._data_divider = data_divider

    def check_endian_isBig(self, endian):
        return True if endian != "little" else False

    def data_type(self):
        return "rs485"

    def set_config(
            self, method, data_num, baudrate, device_id, stop_bits, parity,
            data_size, reg_addr, func_code, count, endian, data_offset,
            data_multiply, data_divider):
        self._start = False
        self._rs485_mgr.create_new_connection(
            method, baudrate, device_id, data_size, stop_bits, parity)
        self._device_id = device_id
        self._data_num = data_num
        self._reg_addr = reg_addr
        self._func_code = func_code
        self._count = count
        self._endian_isBig = self.check_endian_isBig(endian)
        self._data_offset = data_offset
        self._data_multiply = data_multiply
        self._data_divider = data_divider

    def report(self):
        report = None

        if self._start is False:
            return (report, None)

        if self._oneshot is False or \
                (self._oneshot is True and self._oneshot_send is False):
            result = self._rs485_mgr.read(
                device_id=self._device_id,
                reg_addr=self._reg_addr,
                func_code=self._func_code,
                count=self._count,
                endian_isBig=self._endian_isBig)
            if result is None:
                self._oneshot_send = True
                return (report, None)

            result += self._data_offset
            if self._data_multiply != 0:
                result *= self._data_multiply
            if self._data_divider != 0:
                result /= self._data_divider

            if self._data_num == 1:
                report = Report.report_now(
                    "read_addr",
                    RS485_Data1=result
                    )
            elif self._data_num == 2:
                report = Report.report_now(
                    "read_addr",
                    RS485_Data2=result
                    )
            elif self._data_num == 3:
                report = Report.report_now(
                    "read_addr",
                    RS485_Data3=result
                    )
            elif self._data_num == 4:
                report = Report.report_now(
                    "read_addr",
                    RS485_Data4=result
                    )
            self._oneshot_send = True

        return (report, None)

#
# End of File
#
