from ..log import Log
from ..modules.lib.reporter import Reporter
from ..modules.lib.report import Report


class CpuTempReporter(Reporter):
    def __init__(self, start):
        super().__init__(start)

    def data_type(self):
        return 'temperature'

    def report(self):
        log = Log.instance()
        report = None

        if self._start is False:
            return (report, None)
        if self._oneshot is False or \
                (self._oneshot is True and self._oneshot_send is False):
            temp = None
            try:
                with open('/sys/class/thermal/thermal_zone0/temp') as file:
                    temp = int(file.read()) / float(1000)
            except Exception as e:
                log.error("CPU_temp read error.")
                log.error(e.args)

            report = Report.report_now(
                'measurement',
                CPU_temp=temp
            )
            self._oneshot_send = True
        return (report, None)

#
# End of File
#
