import os
from .io.dio_manager_a6e import DIO_Mgr_A6E
from .io.dio_manager_a9e import DIO_Mgr_A9E
from .io.vin_operator import VinIIO

class Product():
    _dio_mgr = None
    _rs485_path = None
    _vin_iios = []

    def __init__(self):
        if "A9E" in os.getenv("AT_PRODUCT_NAME", default=""):
            self._dio_mgr = DIO_Mgr_A9E()
            self._rs485_path = "/dev/ttyrpmsg1"

            vin_iio_a9e_mainboard = VinIIO(dev_id_name='label', dev_id_value='vin',
                                        vin_raw_name='in_voltage0_raw', vin_scale_name='in_voltage0_scale',
                                        r1=910, r2=56, description='A9E Main board')
            self._vin_iios = [vin_iio_a9e_mainboard]
        else:
            # A6E
            self._dio_mgr = DIO_Mgr_A6E()
            self._rs485_path = "/dev/ttymxc4"

            vin_iio_a6e_mainboard = VinIIO(dev_id_name='label', dev_id_value='vin',
                                        vin_raw_name='in_voltage_raw', vin_scale_name='in_voltage_scale',
                                        r1=910, r2=110, description='A6E Main board')
            vin_iio_a6e_diai = VinIIO(dev_id_name='name', dev_id_value='2198000.adc',
                                        vin_raw_name='in_voltage1_raw', vin_scale_name='in_voltage_scale',
                                        r1=910, r2=110, description='A6E +Di8+Ai4 board')
            self._vin_iios = [vin_iio_a6e_mainboard, vin_iio_a6e_diai]

    def dio_mgr(self):
        return self._dio_mgr

    def rs485_path(self):
        return self._rs485_path

    def vin_iios(self):
        return self._vin_iios
