from abc import ABC

from .modules.lib.report_queue import ReportQueue
from .modules.lib.reporter_manager import ReporterManager
from .report_repository import CloudReportRepository


class ModelDevBase(ABC):
    def __init__(self, modelConfig, send_cloud):
        self._props = {}
        self._loopables = []
        self._modelConfig = modelConfig
        self._tempReporter = None
        self._loop = None
        self._cloud_agent = None
        self._send_cloud = send_cloud

    def setup_reporters(self, config, cloud_agent, valid_cache, loop):
        queue = ReportQueue()
        alaram_queue = ReportQueue()
        report_repository = CloudReportRepository(
            queue, alaram_queue, cloud_agent, valid_cache, self._send_cloud,
            loop)
        report_repository.set_interval(config.send_interval())
        manager = ReporterManager(queue, alaram_queue)
        reporters = self._create_reporters(self._modelConfig)
        for reporter in reporters:
            manager.listen_to(reporter)
        self._loopables.append(report_repository)
        self._loopables.append(manager)
        active_reporters = self._create_active_reporters(
            self._modelConfig, queue, report_repository)
        for reporter in active_reporters:
            self._loopables.append(reporter)
        sensing_manager = self._create_sensing_manager(self._modelConfig)
        if sensing_manager is not None:
            self._loopables.append(sensing_manager)

        if self._send_cloud:
            cloud_agent.setcb(report_repository.on_send_cloud_agent,
                              self.on_recv_data)
            self._cloud_agent = cloud_agent
        self._loop = loop

    def loopables(self):
        return self._loopables

    def report_repository(self):
        return self._loopables[0]

    def reporter_manager(self):
        return self._loopables[1]

    async def execute_commnad(self, name, params):
        command_method = self._get_command_method(name)
        return await command_method(params) if command_method else None

    def _create_reporters(self, config):
        reporters = []

        return reporters

    def _create_active_reporters(self, config, report_queue, report_repository):
        return []

    def _create_sensing_manager(self, config):
        return None

#
# End of File
#
