

class LedDevice:
    @staticmethod
    def get(led_name):
        return LedDevice(led_name)

    def __init__(self, led_name):
        self._led_name = led_name
        self._dev_path = "/sys/class/leds/" + led_name + "/"

    def __enter__(self):
        return self

    def __exit__(self, t, v, tb):
        return  # do nothing

    def on_or_off(self, do_on):
        with open(self._dev_path + "trigger", "w") as f:
            f.write("none\n")
        if do_on:
            brightness = "255\n"
            with open(self._dev_path + "max_brightness", "r") as f:
                brightness = f.read()
        else:
            brightness = "0\n"
        with open(self._dev_path + "brightness", "w") as f:
            f.write(brightness)

    def blink_fast(self):
        self._do_blink("222\n")

    def blink_slow(self):
        self._do_blink("888\n")

    def _do_blink(self, delay):
        with open(self._dev_path + "trigger", "w") as f:
            f.write("timer\n")
        with open(self._dev_path + "delay_on", "w") as f:
            f.write(delay)
        with open(self._dev_path + "delay_off", "w") as f:
            f.write(delay)
