import gpiod
from .dio_manager import DIO_Mgr
from ..log import Log


class DIO_Mgr_A9E(DIO_Mgr):
    DI_PORT_MIN = 1
    DI_PORT_MAX = 2
    VOUT_PORT = 0

    def __init__(self):
        self._dins = dict()
        self._douts = dict()
        self._vout = dict()

    def do_port(self, num):
        port = 1
        if num == 1:
            port = 1
        elif num == 2:
            port = 2
        return port

    def _di_port_to_gpio(self, port):
        chip = -1
        line = -1
        if port == 1 or port == 2:
            chip = 1
            if port == 1:
                line = 12
            if port == 2:
                line = 14
        return chip, line

    def _do_port_to_gpio(self, port):
        chip = -1
        line = -1
        if port == 1 or port == 2:
            chip = 1
            if port == 1:
                line = 0
            if port == 2:
                line = 1
        return chip, line

#
# EOF
#
