import time
import asyncio

from .wdt import WatchdogTimer

class ConnectionWatchdog:
    def __init__(self, loop, watch, interval):
        self._watch = watch
        self._interval = interval
        self._wdt = WatchdogTimer()
        self._quit = False
        self._eventloop = loop
        self._task = None

    def __del__(self):
        self.stop()

    def start(self):
        self._wdt.start()
        if self._task == None:
            self._task = self._eventloop.create_task(self._loop())

    def stop(self):
        self._wdt.stop()
        self._quit = True

    async def _loop(self):
        while not self._quit:
            if self._watch():
                self._wdt.reset()
            await asyncio.sleep(self._interval)
