import configparser
import subprocess
import os
import logging

class AzureConfig:
    IOT_DEVICE_DPS_ENDPOINT = "AZURE_IOT_DEVICE_DPS_ENDPOINT"
    IOT_DEVICE_DPS_ID_SCOPE = "AZURE_IOT_DEVICE_DPS_ID_SCOPE"
    IOT_DEVICE_ID = "AZURE_IOT_DEVICE_ID"
    IOT_MODEL_ID = "AZURE_IOT_MODEL_ID"
    IOT_KEY_FILE = "AZURE_IOT_KEY_FILE"
    IOT_CERT_FILE = "AZURE_IOT_CERT_FILE"

    def __init__(self):
        self._configs = {}
        self._isConfigValid = True
        self._logging = logging.getLogger('cloud-agent')

    def get_and_valid_data(self, config_data, dict_data, name, str=True, require=True, file=False):
        try:
            if str:
                get_data = config_data.get(name)
            else:
                get_data = config_data.getint(name)
        except Exception as e:
            self._logging.error("config %s get error.", name)
            self._logging.error("%s : %s", name, e.args)
            get_data = None

        if not get_data:
            if require:
                self._logging.error("%s is not found.", name)
                self._isConfigValid = False
            else:
                self._logging.warning("%s is not found.", name)
        else:
            dict_data[name] = get_data

        if file:
           if not os.path.isfile(dict_data[name]):
               self._logging.error("%s %s is not existed.", name, dict_data[name])
               self._isConfigValid = False

    def load(self, config_data):

        self._configs = { AzureConfig.IOT_DEVICE_DPS_ENDPOINT : "global.azure-devices-provisioning.net",
                          AzureConfig.IOT_DEVICE_DPS_ID_SCOPE : "",
                          AzureConfig.IOT_MODEL_ID : "",
                          AzureConfig.IOT_CERT_FILE : "/cert/device_cert.pem",
                          AzureConfig.IOT_KEY_FILE : "/cert/key.pem",
                          AzureConfig.IOT_DEVICE_ID : ""}

        self.get_and_valid_data(config_data, self._configs, AzureConfig.IOT_DEVICE_DPS_ENDPOINT, require=False)
        self.get_and_valid_data(config_data, self._configs, AzureConfig.IOT_DEVICE_DPS_ID_SCOPE)
        self.get_and_valid_data(config_data, self._configs, AzureConfig.IOT_CERT_FILE, require=False, file=True)
        self.get_and_valid_data(config_data, self._configs, AzureConfig.IOT_KEY_FILE, require=False, file=True)
        envval = os.environ.pop('OPENSSL_CONF')
        self._configs[AzureConfig.IOT_DEVICE_ID] = subprocess.getoutput(
            "openssl x509 -noout -subject -in " + self._configs[AzureConfig.IOT_CERT_FILE] + " | grep subject | cut -d ',' -f 3 | cut -d '=' -f 2"
        )
        os.environ['OPENSSL_CONF'] = envval
        if not self._configs[AzureConfig.IOT_DEVICE_ID]:
            self._logging.error("AZURE_IOT_DEVICE_ID is not found.")
            self._isConfigValid = False

    def get_conf(self):
        return self._configs

    def is_valid(self):
        return self._isConfigValid

#
# End of File
#
