import configparser
import logging, logging.handlers
from .modules.azure_iot_agent.agent import AzureIoT
from .modules.aws_iot_agent.agent import AWSIoT

class CloudAgent:
    def __init__(self, loop, config_path, device_id):
        # read config
        config = configparser.ConfigParser()
        config.optionxform = str
        config.read(config_path)
        service = config.get('CLOUD', 'SERVICE')

        config_data = config[service]

        # init logging
        self._init_logging(config.getboolean('LOG', 'FILE_LOG'), config.getboolean('LOG', 'STREAM_LOG'))

        if service == "AWS":
            self._cloud = AWSIoT(loop, config_data, config_path, device_id)
        elif service == "AZURE":
            self._cloud = AzureIoT(loop, config_data)
        else:
            return False

    def setcb(self, cb_senddata, cb_recvdata):
        self._cloud.setcb(cb_senddata, cb_recvdata)

    def set_errcb(self, cb_error):
        self._cloud.set_errcb(cb_error)

    def _init_logging(self, file, stream):
        # logging
        formatter = logging.Formatter(
            '%(asctime)s <%(levelname)s> : %(message)s')

        logger = logging.getLogger('cloud-agent')
        logger.setLevel(logging.DEBUG)

        if file is True:
            filehandler = logging.handlers.RotatingFileHandler(
                '/log/cloud_agent.log', encoding='utf-8',
                maxBytes=10000, backupCount=10)
            filehandler.setFormatter(formatter)
            logger.addHandler(filehandler)

        if stream is True:
            streamhandler = logging.StreamHandler()
            streamhandler.setFormatter(formatter)
            logger.addHandler(streamhandler)

    async def connect(self):

        return await self._cloud.connect()

    async def disconnect(self):
        
        await self._cloud.disconnect()

    async def send(self, data):
        
        return await self._cloud.send(data)
