#/bin/sh

KEY_FILE="/cert/device/key.pem"
CERT_FILE="/cert/device/device_cert.pem"
KEY_ID="0xF0000110"
CERT_ID="0xF0000111"
EXIT_RESTART=255

DEFAULT_CONFIG_DIR="/etc/atgateway"
CLOUD_CONF="cloud_agent.conf"
SENSING_CONF="sensing_mgr.conf"

if [ -e "/root/gw_container/customize/main.py" ]; then
  CMD="python3 /root/gw_container/customize/main.py -d"
else
  CMD="python3 -m atgateway -d"
fi

getkey() {
  if [ ! -d '/sys/devices/platform/se050-enable' ] \
      && [ "${AT_PRODUCT_NAME#*A6E}" != "$AT_PRODUCT_NAME" ]; then
    gpioset gpiochip3 18=1
    export SE050_NO_PM=true
  fi

  mkdir -p /cert/device

  if [ -e "$CERT_FILE" ] && [ -e "$KEY_FILE" ]; then
    return
  fi
  se05x_getkey "$CERT_ID" "$CERT_FILE.tmp" "$EX_SSS_BOOT_SSS_PORT" || return
  se05x_getkey "$KEY_ID" "$KEY_FILE.tmp" "$EX_SSS_BOOT_SSS_PORT" || return
  sync "$CERT_FILE.tmp" "$KEY_FILE.tmp" || return
  mv "$CERT_FILE.tmp" "$CERT_FILE" || return
  mv "$KEY_FILE.tmp" "$KEY_FILE"
}

check_conf() {
  mkdir -p /config
  for conf in "$CLOUD_CONF" "$SENSING_CONF"; do
    if [ ! -e "/config/$conf" ]; then
        cp "$DEFAULT_CONFIG_DIR/$conf" "/config/$conf" || true
    fi
  done
}

main() {
  getkey || exit
  check_conf

  while true
  do
    $CMD
    # if the exit code is EXIT_RESTART, restart the app
    if [ $? -ne $EXIT_RESTART ]; then
      break
    fi
  done
}

main
