from ..modules.lib.reporter import Reporter
from ..modules.lib.report import Report


class VinReporter(Reporter):
    def __init__(self, start, vin_operator):
        super().__init__(start)
        self._operator = vin_operator

    def data_type(self):
        return "vin"

    def create_report(self):
        val = self._operator.value()
        return Report.report_now(
                    'measurement',
                    VIN=val
                    )

    def report(self):
        report = None

        if self._start is False:
            return (report, None)

        if self._oneshot is False or \
                (self._oneshot is True and self._oneshot_send is False):
            report = self.create_report()
            self._oneshot_send = True

        return (report, None)

#
# End of File
#
