from ..modules.lib.reporter import Reporter
from ..modules.lib.report import Report


class DIReporter(Reporter):
    def __init__(self, start, dio_mgr, type_isPolling, port):
        super().__init__(start)
#       port = 1(DI1), port = 2 (DI2) ... 34 (DI34)
        self._port = port
        self._dio_mgr = dio_mgr
        self._type_isPolling = type_isPolling

    def data_type(self):
        return "di"

    def set_config(self, type_isPolling):
        self._start = False
        self._type_isPolling = type_isPolling

    def create_polling_report(self):
        return Report.report_now_type_val(
                    'measurement',
                    "DI"+str(self._port)+"_polling",
                    self._dio_mgr.get_DI(self._port)
                    )

    def create_edge_report(self):
        return Report.report_now_type_val(
                    'measurement',
                    "DI"+str(self._port)+"_edge",
                    self._dio_mgr.get_DI_edge(self._port)
                    )

    def report(self):
        report = None

        if self._start is False:
            return (report, None)

        if self._oneshot is False or \
                (self._oneshot is True and self._oneshot_send is False):
            if self._type_isPolling:
                report = self.create_polling_report()
            else:
                report = self.create_edge_report()
            self._oneshot_send = True

        return (report, None)

#
# End of File
#
