from ..modules.lib.reporter import Reporter
from ..modules.lib.report import Report


class AinReporter(Reporter):
    def __init__(self, start, ain_operator, port, type_is_current=False):
        super().__init__(start)
        self._port = port
        self._operator = ain_operator
        self._type_is_current = type_is_current

    def data_type(self):
        return "ain"

    def create_report(self):
        if self._type_is_current:
            return Report.report_now_type_val(
                    'measurement',
                    "AIN"+str(self._port)+"_current",
                    self._operator.current(self._port)
                    )
        else:
            return Report.report_now_type_val(
                    'measurement',
                    "AIN"+str(self._port),
                    self._operator.voltage(self._port)
                    )

    def report(self):
        report = None

        if self._start is False:
            return (report, None)

        if self._oneshot is False or \
                (self._oneshot is True and self._oneshot_send is False):
            report = self.create_report()
            self._oneshot_send = True

        return (report, None)

#
# End of File
#
