from abc import ABC, abstractmethod
from .alarm_machine import AlarmMachine


class Reporter(ABC):
    __interval = 30

    @abstractmethod
    def data_type(self):
        pass

    @abstractmethod
    def report(self):
        pass

    def interval(self):
        return self.__interval

    def set_interval(self, interval):
        self.__interval = interval
        return self

    def set_alarm_condition(self, alarm_condition):
        if alarm_condition is None:
            self.__alarm_machine = None
            return

        self.__alarm_machine = AlarmMachine(alarm_condition)

    def alarm_machine(self):
        return self.__alarm_machine

    def oneshot_report(self):
        self._oneshot = True

    def start(self):
        self._start = True

    def stop(self):
        self._start = False

    def __init__(self, start):
        self.__alarm_machine = None
        self._oneshot = False
        self._oneshot_send = False
        self._start = start
