import os
import configparser
import logging
import logging.handlers
import shutil
import itertools
from .const import Const


class Log:
    _instance = None

    def __init__(self):
        self._logging = None
        self._preserved = False

    def __del__(self):
        if self._preserved:
            self.preserved_error_log_func

    def init_logging(self, config_file_path):
        config = configparser.ConfigParser()
        config.read(config_file_path)
        file = config["LOG"].getboolean("file", True)
        stream = config["LOG"].getboolean("stream", False)

        LOG_FILE_PATH = Const.LOG_FILE_PATH
        # logging
        formatter = logging.Formatter(
            '%(asctime)s <%(levelname)s> : %(message)s')

        logger = logging.getLogger(Const.LOGGER_NAME)
        logger.setLevel(logging.DEBUG)

        if file is True:
            filehandler = logging.handlers.RotatingFileHandler(
                LOG_FILE_PATH, encoding='utf-8',
                maxBytes=10000, backupCount=10)
            filehandler.setFormatter(formatter)
            logger.addHandler(filehandler)

        if stream is True:
            streamhandler = logging.StreamHandler()
            streamhandler.setFormatter(formatter)
            logger.addHandler(streamhandler)
        self._logging = logging.getLogger(Const.LOGGER_NAME)

    def info(self, mess):
        if self._logging:
            self._logging.info(mess)

    def warning(self, mess):
        if self._logging:
            self._logging.warning(mess)

    def error(self, mess):
        if self._logging:
            self._logging.error(mess)

    def preserved_error_log(self):
        self._preserved = True

    def preserved_error_log_func(self):
        changed_file_path = Const.ERROR_LOG_FILE_PATH
        num = 0

        if os.path.exists(Const.ERROR_LOG_FILE_PATH):
            for i in itertools.count(1):
                changed_file_path = Const.ERROR_LOG_FILE_PATH + "." + str(i)
                if not os.path.exists(changed_file_path) or i >= 9:
                    num = i
                    break
        shutil.copy(Const.LOG_FILE_PATH, changed_file_path)
        while num > 0:
            tmp = changed_file_path + ".tmp"
            dest = Const.ERROR_LOG_FILE_PATH + "." + str(num)
            source = Const.ERROR_LOG_FILE_PATH + "." + str(num - 1)
            if num == 1:
                tmp = Const.ERROR_LOG_FILE_PATH + "." + str(1) + ".tmp"
                dest = Const.ERROR_LOG_FILE_PATH + "." + str(1)
                source = Const.ERROR_LOG_FILE_PATH
            shutil.copy(dest, tmp)
            shutil.copy(source, dest)
            shutil.copy(tmp, source)
            os.remove(tmp)
            num -= 1

    @classmethod
    def instance(cls):
        if not cls._instance:
            cls._instance = cls()
        return cls._instance
