import gpiod
from .dio_manager import DIO_Mgr
from ..log import Log


class DIO_Mgr_A6E(DIO_Mgr):
    DI_PORT_MIN = 1
    DI_PORT_MAX = 34
    VOUT_PORT = 0

    def __init__(self):
        self._dins = dict()
        self._douts = dict()
        self._vout = dict()

    def do_port(self, num):
        port = 1
        if num == 1:
            port = 1
        elif num == 2:
            port = 2
        return port

    def _di_port_to_gpio(self, port):
        chip = -1
        line = -1
        if port == 1 or port == 2:
            chip = 5
            line = port - 1
        elif port > 2 and port <= self.DI_PORT_MAX:
            chip = int((port - 3) / 8 + 6)
            line = (port - 3) % 8
        return chip, line

    def _do_port_to_gpio(self, port):
        chip = -1
        line = -1
        if port == 1 or port == 2:
            chip = 5
            line = port + 1

        return chip, line

    def _vout_port_to_gpio(self):
        return 0, 3

    def setup_vout(self, desire):
        log = Log.instance()
        try:
            (chip, line) = self._vout_port_to_gpio()
            self._vout['0'] = DIO_Mgr._create_do_attr(chip, line, desire)
            config = gpiod.line_request()
            config.consumer = "DIO_Mgr"
            config.request_type = gpiod.line_request.DIRECTION_OUTPUT
            if self._vout['0'].state == STATE.ENABLE:
                self._vout['0'].state = super._setup_port(self._vout, config, str(super.VOUT_PORT), True)
        except Exception as e:
            log.error(log, "DIO_Mgr: setup_vout() is Error!")
            log.error(log, e.args)

    def set_VOUT(self, isHigh):
        log = Log.instance()
        try:
            self._vout['0'].gpiod_line.set_value(1 if isHigh else 0)
        except Exception:
            log.warning('set_VOUT: has not VOUT informations.')

    def set_VOUT_Output(self, isHigh):
        log = Log.instance()
        try:
            self._vout['0'].gpiod_line.set_value(1 if isHigh else 0)
        except Exception:
            log.warning('set_VOUT_Output: has not VOUT informations.')

    def get_VOUT_status(self):
        log = Log.instance()
        try:
            return self._vout['0'].state
        except Exception:
            log.warning('get_VOUT_status: has not VOUT informations.')
            return super.STATE.DISABLE

    def reset_VOUT(self, val):
        log = Log.instance()
        config = gpiod.line_request()
        config.consumer = "DIO_Mgr"
        config.request_type = gpiod.line_request.DIRECTION_OUTPUT

        try:
            self._vout['0'].val = val
            self._vout['0'].state = super._setup_port(self._vout, config, self.VOUT, True)
        except Exception:
            log.warning('reset_VOUT: has not VOUT informations.')

#
# EOF
#
