import json
import os
from .const import Const
from .modules.lib.mmringbuffer import MemMapRingBuffer
from ..sensing_mgr.log import Log


class Cache:
    def __init__(self):
        file_path = Const.CACHE_FILE_PATH
        self._mmbuf = MemMapRingBuffer(file_path, Const.CACHE_SIZE)

    def remove(self):
        file_path = Const.CACHE_FILE_PATH
        os.remove(file_path)

    def put(self, dict):
        str = json.dumps(dict)
        self._mmbuf.put(str)

    def pop(self):
        dict = None
        try:
            dict = json.loads(self._mmbuf.get())
        except Exception as e:
            log = Log.instance()
            log.error(e.args)
        return dict

    def empty(self):
        return self._mmbuf.empty()

    def clear(self):
        return self._mmbuf.clear()

    def flush(self):
        return self._mmbuf.flush()


#
# EOF
#
