import os
import time
from threading import Thread
from threading import Lock

import logging


EXIT_CODE_RESTART = 255  # same as gw_app.py

class WatchdogTimer:
    def __init__(self):
        self._down_count = 0
        self._quit_requested = False
        self._lock = Lock()
        self._thread = None

    def start(self):
        if self._thread:
            raise Exception("WDT thread has already started.")
        self.reset()
        self._thread = Thread(target=self._thread_proc)
        self._thread.start()

    def stop(self):
        if self._thread:
            self._quit_requested = True
            self._thread.join()
            self._thread = None
            self._quit_requested = False

    def reset(self):
        with self._lock:
            self._down_count = 120  # 2[min]

    def _thread_proc(self):
        while not self._quit_requested:
            time.sleep(1.0)
            with self._lock:
                self._down_count -= 1
                if self._down_count <= 0:
                    logger = logging.getLogger('cloud-agent')
                    logger.error("WDT expired, abort ourself.")
                    os._exit(EXIT_CODE_RESTART)
