//
// power_notification_handler.h
//
#include <stdint.h>
#include <mutex>
#include <time.h>

#include <sys/socket.h>
#include <sys/un.h>


class PowerNotificationHandler {
public:
    PowerNotificationHandler();
    ~PowerNotificationHandler();

    bool    IsValid() const { return (monitorSock_ >= 0); }
    bool    HasPendingSleepConfirmation() const { return hasPendingSleepConfirmation_; }
    bool    WaitSleepNotification(const struct timespec& endTime);
    bool    CheckSleepNotification();
    void    ConfirmSleepAndWaitResume();
    void    WaitWithAutoSleepConfirm(uint32_t secs);
    bool    InhibitSleep();
    void    AllowSleep();
    static PowerNotificationHandler* Singleton();

private:
    bool    DoWaitSleepNotification(const struct timespec& endTime, bool doConfirm);

    int	monitorSock_;
    bool	hasPendingSleepConfirmation_;
    sockaddr_un	rmtAddress_;
    socklen_t   rmtAddrLen_;
    int inhibitSleepCount_;
    int powerUtilsPid_;
    bool    powerUtilsAlive_;

    static PowerNotificationHandler* singleton;
    static std::mutex   mtx;
};

//
// End of File
//
