#pragma once
/**
 * Copyright (C) 2023-2024 Atmark Techno, Inc. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */

#include <aws/crt/JsonObject.h>

#include "command_line_utils.h"

using namespace Aws::Crt;

class MqttHandler
{
public:
    MqttHandler(
        String thingName,
        std::shared_ptr<Mqtt::MqttConnection> connection);
    int Connect(void);
    void Disconnect(void);

private:
    String thingName_;
    std::shared_ptr<Mqtt::MqttConnection> connection_;
    std::promise<void> connectionClosedPromise_;
};
