/**
 * Copyright (C) 2023-2024 Atmark Techno, Inc. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
#pragma once
#include <aws/crt/Types.h>
#include <fstream>

using namespace Aws::Crt;

String getMountSource(const String& mountPoint);
String readFileContents(const String& filePath);
int stoi_safe(const String& str);
int get_nproc(void);
int64_t statvfs_free_kb(const char *path);
bool checkAndCreatePidFile(void);
bool truncateUTF8Str(String& str, int length);
bool removeControlChar(String& str);
