/**
 * Copyright (C) 2023-2024 Atmark Techno, Inc. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */

#include <filesystem>

#include "agent_config.h"
#include "agent_log.h"

namespace fs = std::filesystem;

AgentConfig::AgentConfig(String configPath) : configPath_(configPath)
{
    if (!fs::exists(configPath_))
    {
        AGENT_LOG_DEBUG("No config file, using defaults: %s", configPath_.c_str());
        return;
    }

    try
    {
        property_tree::ini_parser::read_ini(configPath_.c_str(), pt_);
        isConfOpend_ = true;
    }
    catch (const property_tree::ini_parser_error& e)
    {
        AGENT_LOG_WARN("%s", e.what());
    }
}

String AgentConfig::get(String key)
{
    if (optional<String> value = pt_.get_optional<String>(key.c_str()))
    {
        return value.get();
    }
    else if (isConfOpend_)
    {
        // conf file exists, but no corresponding key
        AGENT_LOG_DEBUG("%s is not found in %s", key.c_str(), configPath_.c_str());
    }
    return "";
}
