/**
 * Copyright (C) 2023-2024 Atmark Techno, Inc. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */

#pragma once
#include <chrono>
#include <aws/crt/JsonObject.h>
#include "agent_time.h"
#include "dbus.h"

using namespace Aws::Crt;

class Shadow
{
public:
    virtual ~Shadow(void);
    virtual JsonObject get(void) = 0;
    void AppendTimeStamp(JsonObject &shadow);
};

class DeviceInfoShadow: public Shadow
{
public:
    DeviceInfoShadow(bool isCommandExecAllowed);
    JsonObject get(void);

private:
    bool isCommandExecAllowed_ = false;
    void AppendSWVersions(JsonObject &shadow);
    void AppendDeviceId(JsonObject &shadow);
    void AppendCommandExecAllowed(JsonObject &shadow);
    void AppendAgentVersion(JsonObject &shadow);
    void AppendBootTime(JsonObject &shadow);
};

// data class for DiskIo stats
class DiskIoStats
{
public:
    unsigned long reads, writes;
    bool seen;
};

class HeartBeatShadow: public Shadow
{
public:
    HeartBeatShadow(String pingDst);
    JsonObject get(void);

private:
    String bootDevice_;
    String pingDst_;
    int nproc_;
    bool firstRun_ = true;
    monotonic_point lastRunTs_;
    // last values for CPUInfo
    uint64_t cpuIdle_ = 0, cpuUser_ = 0, cpuSystem_ = 0, cpuInterrupt_ = 0, cpuOther_ = 0;
    // last values for DiskIo, map per disk
    UnorderedMap<std::string, DiskIoStats*> diskIoStats_;

    int CountString(String str, String sub);
    void AppendCPUTemp(JsonObject &shadow);
    void AppendCPUInfo(JsonObject &shadow);
    void AppendNetPing(JsonObject &shadow);
    void AppendAppAvailableSpace(JsonObject &shadow);
    void AppendMemoryAvailableSpace(JsonObject &shadow);
    void AppendOneDiskIo(JsonObject &shadow, String name);
    void AppendDiskIo(JsonObject &shadow);
    void AppendEmmcPreEolInfo(JsonObject &shadow);
    void AppendContainerStatus(JsonObject &shadow);
    void AppendCellularSiganalQuality(JsonObject &shadow, DBusConnection *dbus);
    void AppendCellularLocation(JsonObject &shadow, DBusConnection *dbus);
};

class DeviceActivityShadow : public Shadow
{
public:
    DeviceActivityShadow(const char* activityStatus) : activityStatus_(activityStatus) {}
    JsonObject  get(void);

private:
    String  activityStatus_;
};

