/**
 * Copyright (C) 2023-2024 Atmark Techno, Inc. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */

#pragma once
#include <aws/iotshadow/IotShadowClient.h>

using namespace Aws::Crt;
using namespace Aws::Iotshadow;

class ShadowHandler
{
public:
    ShadowHandler(
        String thingName,
        String shadowName);
    ~ShadowHandler(void);
    bool Subscribe(std::shared_ptr<Mqtt::MqttConnection> connection);
    bool UpdateShadow(JsonObject shadow, const char* shadowName = NULL);

private:
    String thingName_;
    String shadowName_;
    IotShadowClient* shadowClient_ = nullptr;
};
