/**
 * Copyright (C) 2023-2024 Atmark Techno, Inc. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */

#include "shadow_factory.h"

ShadowFactory::ShadowFactory(String pingDst) : pingDst_(pingDst) {};

Shadow* ShadowFactory::CreateShadow(ShadowPurpose purpose,
                                    bool isCommandExecAllowed)
{
    switch (purpose)
    {
    default:
    case (DeviceInfo):
        return new DeviceInfoShadow(isCommandExecAllowed);
    case (HeartBeat):
        return new HeartBeatShadow(pingDst_);
    }
}
