#pragma once

/* Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 *
 * This file is generated
 */

#include <aws/crt/DateTime.h>
#include <aws/iotshadow/ShadowMetadata.h>
#include <aws/iotshadow/ShadowState.h>

#include <aws/iotshadow/Exports.h>

#include <aws/crt/JsonObject.h>
#include <aws/crt/StlAllocator.h>

namespace Aws
{
    namespace Iotshadow
    {

        /**
         * Response payload to an UpdateShadow request.
         *
         */
        class AWS_IOTSHADOW_API UpdateShadowResponse final
        {
          public:
            UpdateShadowResponse() = default;

            UpdateShadowResponse(const Crt::JsonView &doc);
            UpdateShadowResponse &operator=(const Crt::JsonView &doc);

            void SerializeToObject(Crt::JsonObject &doc) const;

            /**
             * Updated device shadow state.
             *
             */
            Aws::Crt::Optional<Aws::Iotshadow::ShadowState> State;

            /**
             * An opaque token used to correlate requests and responses.  Present only if a client token was used in the
             * request.
             *
             */
            Aws::Crt::Optional<Aws::Crt::String> ClientToken;

            /**
             * The current version of the document for the device's shadow shared in AWS IoT. It is increased by one
             * over the previous version of the document.
             *
             */
            Aws::Crt::Optional<int32_t> Version;

            /**
             * Contains the timestamps for each attribute in the desired and reported sections so that you can determine
             * when the state was updated.
             *
             */
            Aws::Crt::Optional<Aws::Iotshadow::ShadowMetadata> Metadata;

            /**
             * The time the response was generated by AWS IoT.
             *
             */
            Aws::Crt::Optional<Aws::Crt::DateTime> Timestamp;

          private:
            static void LoadFromObject(UpdateShadowResponse &obj, const Crt::JsonView &doc);
        };
    } // namespace Iotshadow
} // namespace Aws
