#pragma once

/* Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 *
 * This file is generated
 */

#include <aws/iotshadow/Exports.h>

#include <aws/crt/JsonObject.h>
#include <aws/crt/StlAllocator.h>

namespace Aws
{
    namespace Iotshadow
    {

        /**
         * Data needed to make a DeleteNamedShadow request.
         *
         */
        class AWS_IOTSHADOW_API DeleteNamedShadowRequest final
        {
          public:
            DeleteNamedShadowRequest() = default;

            DeleteNamedShadowRequest(const Crt::JsonView &doc);
            DeleteNamedShadowRequest &operator=(const Crt::JsonView &doc);

            void SerializeToObject(Crt::JsonObject &doc) const;

            /**
             * Optional. A client token used to correlate requests and responses. Enter an arbitrary value here and it
             * is reflected in the response.
             *
             */
            Aws::Crt::Optional<Aws::Crt::String> ClientToken;

            /**
             * Name of the shadow to delete.
             *
             */
            Aws::Crt::Optional<Aws::Crt::String> ShadowName;

            /**
             * AWS IoT thing to delete a named shadow from.
             *
             */
            Aws::Crt::Optional<Aws::Crt::String> ThingName;

          private:
            static void LoadFromObject(DeleteNamedShadowRequest &obj, const Crt::JsonView &doc);
        };
    } // namespace Iotshadow
} // namespace Aws
