#pragma once

/* Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 *
 * This file is generated
 */

#include <aws/iotidentity/Exports.h>

#include <aws/crt/JsonObject.h>
#include <aws/crt/StlAllocator.h>

namespace Aws
{
    namespace Iotidentity
    {

        /**
         * Data needed to perform a RegisterThing operation.
         *
         */
        class AWS_IOTIDENTITY_API RegisterThingRequest final
        {
          public:
            RegisterThingRequest() = default;

            RegisterThingRequest(const Crt::JsonView &doc);
            RegisterThingRequest &operator=(const Crt::JsonView &doc);

            void SerializeToObject(Crt::JsonObject &doc) const;

            /**
             * The provisioning template name.
             *
             */
            Aws::Crt::Optional<Aws::Crt::String> TemplateName;

            /**
             * Optional. Key-value pairs from the device that are used by the pre-provisioning hooks to evaluate the
             * registration request.
             *
             */
            Aws::Crt::Optional<Aws::Crt::Map<Aws::Crt::String, Aws::Crt::String>> Parameters;

            /**
             * The token to prove ownership of the certificate. The token is generated by AWS IoT when you create a
             * certificate over MQTT.
             *
             */
            Aws::Crt::Optional<Aws::Crt::String> CertificateOwnershipToken;

          private:
            static void LoadFromObject(RegisterThingRequest &obj, const Crt::JsonView &doc);
        };
    } // namespace Iotidentity
} // namespace Aws
