package main

// Code generated by /home/ec2-user/go/bin/peg ./delocate.peg DO NOT EDIT.

import (
	"fmt"
	"io"
	"os"
	"sort"
	"strconv"
	"strings"
)

const endSymbol rune = 1114112

/* The rule types inferred from the grammar are below. */
type pegRule uint8

const (
	ruleUnknown pegRule = iota
	ruleAsmFile
	ruleStatement
	ruleGlobalDirective
	ruleDirective
	ruleDirectiveName
	ruleLocationDirective
	ruleFileDirective
	ruleLocDirective
	ruleArgs
	ruleArg
	ruleQuotedArg
	ruleQuotedText
	ruleLabelContainingDirective
	ruleLabelContainingDirectiveName
	ruleSymbolArgs
	ruleSymbolShift
	ruleSymbolArg
	ruleOpenParen
	ruleCloseParen
	ruleSymbolType
	ruleDot
	ruleTCMarker
	ruleEscapedChar
	ruleWS
	ruleComment
	ruleLabel
	ruleSymbolName
	ruleLocalSymbol
	ruleLocalLabel
	ruleLocalLabelRef
	ruleInstruction
	ruleInstructionName
	ruleInstructionArg
	ruleGOTLocation
	ruleGOTSymbolOffset
	ruleAVX512Token
	ruleTOCRefHigh
	ruleTOCRefLow
	ruleIndirectionIndicator
	ruleRegisterOrConstant
	ruleARMConstantTweak
	ruleARMRegister
	ruleARMVectorRegister
	ruleMemoryRef
	ruleSymbolRef
	ruleLow12BitsSymbolRef
	ruleARMBaseIndexScale
	ruleARMGOTLow12
	ruleARMPostincrement
	ruleBaseIndexScale
	ruleOperator
	ruleOffsetOperator
	ruleOffset
	ruleSection
	ruleSegmentRegister
)

var rul3s = [...]string{
	"Unknown",
	"AsmFile",
	"Statement",
	"GlobalDirective",
	"Directive",
	"DirectiveName",
	"LocationDirective",
	"FileDirective",
	"LocDirective",
	"Args",
	"Arg",
	"QuotedArg",
	"QuotedText",
	"LabelContainingDirective",
	"LabelContainingDirectiveName",
	"SymbolArgs",
	"SymbolShift",
	"SymbolArg",
	"OpenParen",
	"CloseParen",
	"SymbolType",
	"Dot",
	"TCMarker",
	"EscapedChar",
	"WS",
	"Comment",
	"Label",
	"SymbolName",
	"LocalSymbol",
	"LocalLabel",
	"LocalLabelRef",
	"Instruction",
	"InstructionName",
	"InstructionArg",
	"GOTLocation",
	"GOTSymbolOffset",
	"AVX512Token",
	"TOCRefHigh",
	"TOCRefLow",
	"IndirectionIndicator",
	"RegisterOrConstant",
	"ARMConstantTweak",
	"ARMRegister",
	"ARMVectorRegister",
	"MemoryRef",
	"SymbolRef",
	"Low12BitsSymbolRef",
	"ARMBaseIndexScale",
	"ARMGOTLow12",
	"ARMPostincrement",
	"BaseIndexScale",
	"Operator",
	"OffsetOperator",
	"Offset",
	"Section",
	"SegmentRegister",
}

type token32 struct {
	pegRule
	begin, end uint32
}

func (t *token32) String() string {
	return fmt.Sprintf("\x1B[34m%v\x1B[m %v %v", rul3s[t.pegRule], t.begin, t.end)
}

type node32 struct {
	token32
	up, next *node32
}

func (node *node32) print(w io.Writer, pretty bool, buffer string) {
	var print func(node *node32, depth int)
	print = func(node *node32, depth int) {
		for node != nil {
			for c := 0; c < depth; c++ {
				fmt.Fprintf(w, " ")
			}
			rule := rul3s[node.pegRule]
			quote := strconv.Quote(string(([]rune(buffer)[node.begin:node.end])))
			if !pretty {
				fmt.Fprintf(w, "%v %v\n", rule, quote)
			} else {
				fmt.Fprintf(w, "\x1B[36m%v\x1B[m %v\n", rule, quote)
			}
			if node.up != nil {
				print(node.up, depth+1)
			}
			node = node.next
		}
	}
	print(node, 0)
}

func (node *node32) Print(w io.Writer, buffer string) {
	node.print(w, false, buffer)
}

func (node *node32) PrettyPrint(w io.Writer, buffer string) {
	node.print(w, true, buffer)
}

type tokens32 struct {
	tree []token32
}

func (t *tokens32) Trim(length uint32) {
	t.tree = t.tree[:length]
}

func (t *tokens32) Print() {
	for _, token := range t.tree {
		fmt.Println(token.String())
	}
}

func (t *tokens32) AST() *node32 {
	type element struct {
		node *node32
		down *element
	}
	tokens := t.Tokens()
	var stack *element
	for _, token := range tokens {
		if token.begin == token.end {
			continue
		}
		node := &node32{token32: token}
		for stack != nil && stack.node.begin >= token.begin && stack.node.end <= token.end {
			stack.node.next = node.up
			node.up = stack.node
			stack = stack.down
		}
		stack = &element{node: node, down: stack}
	}
	if stack != nil {
		return stack.node
	}
	return nil
}

func (t *tokens32) PrintSyntaxTree(buffer string) {
	t.AST().Print(os.Stdout, buffer)
}

func (t *tokens32) WriteSyntaxTree(w io.Writer, buffer string) {
	t.AST().Print(w, buffer)
}

func (t *tokens32) PrettyPrintSyntaxTree(buffer string) {
	t.AST().PrettyPrint(os.Stdout, buffer)
}

func (t *tokens32) Add(rule pegRule, begin, end, index uint32) {
	tree, i := t.tree, int(index)
	if i >= len(tree) {
		t.tree = append(tree, token32{pegRule: rule, begin: begin, end: end})
		return
	}
	tree[i] = token32{pegRule: rule, begin: begin, end: end}
}

func (t *tokens32) Tokens() []token32 {
	return t.tree
}

type Asm struct {
	Buffer string
	buffer []rune
	rules  [56]func() bool
	parse  func(rule ...int) error
	reset  func()
	Pretty bool
	tokens32
}

func (p *Asm) Parse(rule ...int) error {
	return p.parse(rule...)
}

func (p *Asm) Reset() {
	p.reset()
}

type textPosition struct {
	line, symbol int
}

type textPositionMap map[int]textPosition

func translatePositions(buffer []rune, positions []int) textPositionMap {
	length, translations, j, line, symbol := len(positions), make(textPositionMap, len(positions)), 0, 1, 0
	sort.Ints(positions)

search:
	for i, c := range buffer {
		if c == '\n' {
			line, symbol = line+1, 0
		} else {
			symbol++
		}
		if i == positions[j] {
			translations[positions[j]] = textPosition{line, symbol}
			for j++; j < length; j++ {
				if i != positions[j] {
					continue search
				}
			}
			break search
		}
	}

	return translations
}

type parseError struct {
	p   *Asm
	max token32
}

func (e *parseError) Error() string {
	tokens, err := []token32{e.max}, "\n"
	positions, p := make([]int, 2*len(tokens)), 0
	for _, token := range tokens {
		positions[p], p = int(token.begin), p+1
		positions[p], p = int(token.end), p+1
	}
	translations := translatePositions(e.p.buffer, positions)
	format := "parse error near %v (line %v symbol %v - line %v symbol %v):\n%v\n"
	if e.p.Pretty {
		format = "parse error near \x1B[34m%v\x1B[m (line %v symbol %v - line %v symbol %v):\n%v\n"
	}
	for _, token := range tokens {
		begin, end := int(token.begin), int(token.end)
		err += fmt.Sprintf(format,
			rul3s[token.pegRule],
			translations[begin].line, translations[begin].symbol,
			translations[end].line, translations[end].symbol,
			strconv.Quote(string(e.p.buffer[begin:end])))
	}

	return err
}

func (p *Asm) PrintSyntaxTree() {
	if p.Pretty {
		p.tokens32.PrettyPrintSyntaxTree(p.Buffer)
	} else {
		p.tokens32.PrintSyntaxTree(p.Buffer)
	}
}

func (p *Asm) WriteSyntaxTree(w io.Writer) {
	p.tokens32.WriteSyntaxTree(w, p.Buffer)
}

func (p *Asm) SprintSyntaxTree() string {
	var bldr strings.Builder
	p.WriteSyntaxTree(&bldr)
	return bldr.String()
}

func Pretty(pretty bool) func(*Asm) error {
	return func(p *Asm) error {
		p.Pretty = pretty
		return nil
	}
}

func Size(size int) func(*Asm) error {
	return func(p *Asm) error {
		p.tokens32 = tokens32{tree: make([]token32, 0, size)}
		return nil
	}
}
func (p *Asm) Init(options ...func(*Asm) error) error {
	var (
		max                  token32
		position, tokenIndex uint32
		buffer               []rune
	)
	for _, option := range options {
		err := option(p)
		if err != nil {
			return err
		}
	}
	p.reset = func() {
		max = token32{}
		position, tokenIndex = 0, 0

		p.buffer = []rune(p.Buffer)
		if len(p.buffer) == 0 || p.buffer[len(p.buffer)-1] != endSymbol {
			p.buffer = append(p.buffer, endSymbol)
		}
		buffer = p.buffer
	}
	p.reset()

	_rules := p.rules
	tree := p.tokens32
	p.parse = func(rule ...int) error {
		r := 1
		if len(rule) > 0 {
			r = rule[0]
		}
		matches := p.rules[r]()
		p.tokens32 = tree
		if matches {
			p.Trim(tokenIndex)
			return nil
		}
		return &parseError{p, max}
	}

	add := func(rule pegRule, begin uint32) {
		tree.Add(rule, begin, position, tokenIndex)
		tokenIndex++
		if begin != position && position > max.end {
			max = token32{rule, begin, position}
		}
	}

	matchDot := func() bool {
		if buffer[position] != endSymbol {
			position++
			return true
		}
		return false
	}

	/*matchChar := func(c byte) bool {
		if buffer[position] == c {
			position++
			return true
		}
		return false
	}*/

	/*matchRange := func(lower byte, upper byte) bool {
		if c := buffer[position]; c >= lower && c <= upper {
			position++
			return true
		}
		return false
	}*/

	_rules = [...]func() bool{
		nil,
		/* 0 AsmFile <- <(Statement* !.)> */
		func() bool {
			position0, tokenIndex0 := position, tokenIndex
			{
				position1 := position
			l2:
				{
					position3, tokenIndex3 := position, tokenIndex
					if !_rules[ruleStatement]() {
						goto l3
					}
					goto l2
				l3:
					position, tokenIndex = position3, tokenIndex3
				}
				{
					position4, tokenIndex4 := position, tokenIndex
					if !matchDot() {
						goto l4
					}
					goto l0
				l4:
					position, tokenIndex = position4, tokenIndex4
				}
				add(ruleAsmFile, position1)
			}
			return true
		l0:
			position, tokenIndex = position0, tokenIndex0
			return false
		},
		/* 1 Statement <- <(WS? (Label / ((GlobalDirective / LocationDirective / LabelContainingDirective / Instruction / Directive / Comment / ) WS? ((Comment? '\n') / ';'))))> */
		func() bool {
			position5, tokenIndex5 := position, tokenIndex
			{
				position6 := position
				{
					position7, tokenIndex7 := position, tokenIndex
					if !_rules[ruleWS]() {
						goto l7
					}
					goto l8
				l7:
					position, tokenIndex = position7, tokenIndex7
				}
			l8:
				{
					position9, tokenIndex9 := position, tokenIndex
					if !_rules[ruleLabel]() {
						goto l10
					}
					goto l9
				l10:
					position, tokenIndex = position9, tokenIndex9
					{
						position11, tokenIndex11 := position, tokenIndex
						if !_rules[ruleGlobalDirective]() {
							goto l12
						}
						goto l11
					l12:
						position, tokenIndex = position11, tokenIndex11
						if !_rules[ruleLocationDirective]() {
							goto l13
						}
						goto l11
					l13:
						position, tokenIndex = position11, tokenIndex11
						if !_rules[ruleLabelContainingDirective]() {
							goto l14
						}
						goto l11
					l14:
						position, tokenIndex = position11, tokenIndex11
						if !_rules[ruleInstruction]() {
							goto l15
						}
						goto l11
					l15:
						position, tokenIndex = position11, tokenIndex11
						if !_rules[ruleDirective]() {
							goto l16
						}
						goto l11
					l16:
						position, tokenIndex = position11, tokenIndex11
						if !_rules[ruleComment]() {
							goto l17
						}
						goto l11
					l17:
						position, tokenIndex = position11, tokenIndex11
					}
				l11:
					{
						position18, tokenIndex18 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l18
						}
						goto l19
					l18:
						position, tokenIndex = position18, tokenIndex18
					}
				l19:
					{
						position20, tokenIndex20 := position, tokenIndex
						{
							position22, tokenIndex22 := position, tokenIndex
							if !_rules[ruleComment]() {
								goto l22
							}
							goto l23
						l22:
							position, tokenIndex = position22, tokenIndex22
						}
					l23:
						if buffer[position] != rune('\n') {
							goto l21
						}
						position++
						goto l20
					l21:
						position, tokenIndex = position20, tokenIndex20
						if buffer[position] != rune(';') {
							goto l5
						}
						position++
					}
				l20:
				}
			l9:
				add(ruleStatement, position6)
			}
			return true
		l5:
			position, tokenIndex = position5, tokenIndex5
			return false
		},
		/* 2 GlobalDirective <- <((('.' ('g' / 'G') ('l' / 'L') ('o' / 'O') ('b' / 'B') ('a' / 'A') ('l' / 'L')) / ('.' ('g' / 'G') ('l' / 'L') ('o' / 'O') ('b' / 'B') ('l' / 'L'))) WS SymbolName)> */
		func() bool {
			position24, tokenIndex24 := position, tokenIndex
			{
				position25 := position
				{
					position26, tokenIndex26 := position, tokenIndex
					if buffer[position] != rune('.') {
						goto l27
					}
					position++
					{
						position28, tokenIndex28 := position, tokenIndex
						if buffer[position] != rune('g') {
							goto l29
						}
						position++
						goto l28
					l29:
						position, tokenIndex = position28, tokenIndex28
						if buffer[position] != rune('G') {
							goto l27
						}
						position++
					}
				l28:
					{
						position30, tokenIndex30 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l31
						}
						position++
						goto l30
					l31:
						position, tokenIndex = position30, tokenIndex30
						if buffer[position] != rune('L') {
							goto l27
						}
						position++
					}
				l30:
					{
						position32, tokenIndex32 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l33
						}
						position++
						goto l32
					l33:
						position, tokenIndex = position32, tokenIndex32
						if buffer[position] != rune('O') {
							goto l27
						}
						position++
					}
				l32:
					{
						position34, tokenIndex34 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l35
						}
						position++
						goto l34
					l35:
						position, tokenIndex = position34, tokenIndex34
						if buffer[position] != rune('B') {
							goto l27
						}
						position++
					}
				l34:
					{
						position36, tokenIndex36 := position, tokenIndex
						if buffer[position] != rune('a') {
							goto l37
						}
						position++
						goto l36
					l37:
						position, tokenIndex = position36, tokenIndex36
						if buffer[position] != rune('A') {
							goto l27
						}
						position++
					}
				l36:
					{
						position38, tokenIndex38 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l39
						}
						position++
						goto l38
					l39:
						position, tokenIndex = position38, tokenIndex38
						if buffer[position] != rune('L') {
							goto l27
						}
						position++
					}
				l38:
					goto l26
				l27:
					position, tokenIndex = position26, tokenIndex26
					if buffer[position] != rune('.') {
						goto l24
					}
					position++
					{
						position40, tokenIndex40 := position, tokenIndex
						if buffer[position] != rune('g') {
							goto l41
						}
						position++
						goto l40
					l41:
						position, tokenIndex = position40, tokenIndex40
						if buffer[position] != rune('G') {
							goto l24
						}
						position++
					}
				l40:
					{
						position42, tokenIndex42 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l43
						}
						position++
						goto l42
					l43:
						position, tokenIndex = position42, tokenIndex42
						if buffer[position] != rune('L') {
							goto l24
						}
						position++
					}
				l42:
					{
						position44, tokenIndex44 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l45
						}
						position++
						goto l44
					l45:
						position, tokenIndex = position44, tokenIndex44
						if buffer[position] != rune('O') {
							goto l24
						}
						position++
					}
				l44:
					{
						position46, tokenIndex46 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l47
						}
						position++
						goto l46
					l47:
						position, tokenIndex = position46, tokenIndex46
						if buffer[position] != rune('B') {
							goto l24
						}
						position++
					}
				l46:
					{
						position48, tokenIndex48 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l49
						}
						position++
						goto l48
					l49:
						position, tokenIndex = position48, tokenIndex48
						if buffer[position] != rune('L') {
							goto l24
						}
						position++
					}
				l48:
				}
			l26:
				if !_rules[ruleWS]() {
					goto l24
				}
				if !_rules[ruleSymbolName]() {
					goto l24
				}
				add(ruleGlobalDirective, position25)
			}
			return true
		l24:
			position, tokenIndex = position24, tokenIndex24
			return false
		},
		/* 3 Directive <- <('.' DirectiveName (WS Args)?)> */
		func() bool {
			position50, tokenIndex50 := position, tokenIndex
			{
				position51 := position
				if buffer[position] != rune('.') {
					goto l50
				}
				position++
				if !_rules[ruleDirectiveName]() {
					goto l50
				}
				{
					position52, tokenIndex52 := position, tokenIndex
					if !_rules[ruleWS]() {
						goto l52
					}
					if !_rules[ruleArgs]() {
						goto l52
					}
					goto l53
				l52:
					position, tokenIndex = position52, tokenIndex52
				}
			l53:
				add(ruleDirective, position51)
			}
			return true
		l50:
			position, tokenIndex = position50, tokenIndex50
			return false
		},
		/* 4 DirectiveName <- <([a-z] / [A-Z] / ([0-9] / [0-9]) / '_')+> */
		func() bool {
			position54, tokenIndex54 := position, tokenIndex
			{
				position55 := position
				{
					position58, tokenIndex58 := position, tokenIndex
					if c := buffer[position]; c < rune('a') || c > rune('z') {
						goto l59
					}
					position++
					goto l58
				l59:
					position, tokenIndex = position58, tokenIndex58
					if c := buffer[position]; c < rune('A') || c > rune('Z') {
						goto l60
					}
					position++
					goto l58
				l60:
					position, tokenIndex = position58, tokenIndex58
					{
						position62, tokenIndex62 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l63
						}
						position++
						goto l62
					l63:
						position, tokenIndex = position62, tokenIndex62
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l61
						}
						position++
					}
				l62:
					goto l58
				l61:
					position, tokenIndex = position58, tokenIndex58
					if buffer[position] != rune('_') {
						goto l54
					}
					position++
				}
			l58:
			l56:
				{
					position57, tokenIndex57 := position, tokenIndex
					{
						position64, tokenIndex64 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l65
						}
						position++
						goto l64
					l65:
						position, tokenIndex = position64, tokenIndex64
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l66
						}
						position++
						goto l64
					l66:
						position, tokenIndex = position64, tokenIndex64
						{
							position68, tokenIndex68 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l69
							}
							position++
							goto l68
						l69:
							position, tokenIndex = position68, tokenIndex68
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l67
							}
							position++
						}
					l68:
						goto l64
					l67:
						position, tokenIndex = position64, tokenIndex64
						if buffer[position] != rune('_') {
							goto l57
						}
						position++
					}
				l64:
					goto l56
				l57:
					position, tokenIndex = position57, tokenIndex57
				}
				add(ruleDirectiveName, position55)
			}
			return true
		l54:
			position, tokenIndex = position54, tokenIndex54
			return false
		},
		/* 5 LocationDirective <- <(FileDirective / LocDirective)> */
		func() bool {
			position70, tokenIndex70 := position, tokenIndex
			{
				position71 := position
				{
					position72, tokenIndex72 := position, tokenIndex
					if !_rules[ruleFileDirective]() {
						goto l73
					}
					goto l72
				l73:
					position, tokenIndex = position72, tokenIndex72
					if !_rules[ruleLocDirective]() {
						goto l70
					}
				}
			l72:
				add(ruleLocationDirective, position71)
			}
			return true
		l70:
			position, tokenIndex = position70, tokenIndex70
			return false
		},
		/* 6 FileDirective <- <('.' ('f' / 'F') ('i' / 'I') ('l' / 'L') ('e' / 'E') WS (!('#' / '\n') .)+)> */
		func() bool {
			position74, tokenIndex74 := position, tokenIndex
			{
				position75 := position
				if buffer[position] != rune('.') {
					goto l74
				}
				position++
				{
					position76, tokenIndex76 := position, tokenIndex
					if buffer[position] != rune('f') {
						goto l77
					}
					position++
					goto l76
				l77:
					position, tokenIndex = position76, tokenIndex76
					if buffer[position] != rune('F') {
						goto l74
					}
					position++
				}
			l76:
				{
					position78, tokenIndex78 := position, tokenIndex
					if buffer[position] != rune('i') {
						goto l79
					}
					position++
					goto l78
				l79:
					position, tokenIndex = position78, tokenIndex78
					if buffer[position] != rune('I') {
						goto l74
					}
					position++
				}
			l78:
				{
					position80, tokenIndex80 := position, tokenIndex
					if buffer[position] != rune('l') {
						goto l81
					}
					position++
					goto l80
				l81:
					position, tokenIndex = position80, tokenIndex80
					if buffer[position] != rune('L') {
						goto l74
					}
					position++
				}
			l80:
				{
					position82, tokenIndex82 := position, tokenIndex
					if buffer[position] != rune('e') {
						goto l83
					}
					position++
					goto l82
				l83:
					position, tokenIndex = position82, tokenIndex82
					if buffer[position] != rune('E') {
						goto l74
					}
					position++
				}
			l82:
				if !_rules[ruleWS]() {
					goto l74
				}
				{
					position86, tokenIndex86 := position, tokenIndex
					{
						position87, tokenIndex87 := position, tokenIndex
						if buffer[position] != rune('#') {
							goto l88
						}
						position++
						goto l87
					l88:
						position, tokenIndex = position87, tokenIndex87
						if buffer[position] != rune('\n') {
							goto l86
						}
						position++
					}
				l87:
					goto l74
				l86:
					position, tokenIndex = position86, tokenIndex86
				}
				if !matchDot() {
					goto l74
				}
			l84:
				{
					position85, tokenIndex85 := position, tokenIndex
					{
						position89, tokenIndex89 := position, tokenIndex
						{
							position90, tokenIndex90 := position, tokenIndex
							if buffer[position] != rune('#') {
								goto l91
							}
							position++
							goto l90
						l91:
							position, tokenIndex = position90, tokenIndex90
							if buffer[position] != rune('\n') {
								goto l89
							}
							position++
						}
					l90:
						goto l85
					l89:
						position, tokenIndex = position89, tokenIndex89
					}
					if !matchDot() {
						goto l85
					}
					goto l84
				l85:
					position, tokenIndex = position85, tokenIndex85
				}
				add(ruleFileDirective, position75)
			}
			return true
		l74:
			position, tokenIndex = position74, tokenIndex74
			return false
		},
		/* 7 LocDirective <- <('.' ('l' / 'L') ('o' / 'O') ('c' / 'C') WS (!('#' / '/' / '\n') .)+)> */
		func() bool {
			position92, tokenIndex92 := position, tokenIndex
			{
				position93 := position
				if buffer[position] != rune('.') {
					goto l92
				}
				position++
				{
					position94, tokenIndex94 := position, tokenIndex
					if buffer[position] != rune('l') {
						goto l95
					}
					position++
					goto l94
				l95:
					position, tokenIndex = position94, tokenIndex94
					if buffer[position] != rune('L') {
						goto l92
					}
					position++
				}
			l94:
				{
					position96, tokenIndex96 := position, tokenIndex
					if buffer[position] != rune('o') {
						goto l97
					}
					position++
					goto l96
				l97:
					position, tokenIndex = position96, tokenIndex96
					if buffer[position] != rune('O') {
						goto l92
					}
					position++
				}
			l96:
				{
					position98, tokenIndex98 := position, tokenIndex
					if buffer[position] != rune('c') {
						goto l99
					}
					position++
					goto l98
				l99:
					position, tokenIndex = position98, tokenIndex98
					if buffer[position] != rune('C') {
						goto l92
					}
					position++
				}
			l98:
				if !_rules[ruleWS]() {
					goto l92
				}
				{
					position102, tokenIndex102 := position, tokenIndex
					{
						position103, tokenIndex103 := position, tokenIndex
						if buffer[position] != rune('#') {
							goto l104
						}
						position++
						goto l103
					l104:
						position, tokenIndex = position103, tokenIndex103
						if buffer[position] != rune('/') {
							goto l105
						}
						position++
						goto l103
					l105:
						position, tokenIndex = position103, tokenIndex103
						if buffer[position] != rune('\n') {
							goto l102
						}
						position++
					}
				l103:
					goto l92
				l102:
					position, tokenIndex = position102, tokenIndex102
				}
				if !matchDot() {
					goto l92
				}
			l100:
				{
					position101, tokenIndex101 := position, tokenIndex
					{
						position106, tokenIndex106 := position, tokenIndex
						{
							position107, tokenIndex107 := position, tokenIndex
							if buffer[position] != rune('#') {
								goto l108
							}
							position++
							goto l107
						l108:
							position, tokenIndex = position107, tokenIndex107
							if buffer[position] != rune('/') {
								goto l109
							}
							position++
							goto l107
						l109:
							position, tokenIndex = position107, tokenIndex107
							if buffer[position] != rune('\n') {
								goto l106
							}
							position++
						}
					l107:
						goto l101
					l106:
						position, tokenIndex = position106, tokenIndex106
					}
					if !matchDot() {
						goto l101
					}
					goto l100
				l101:
					position, tokenIndex = position101, tokenIndex101
				}
				add(ruleLocDirective, position93)
			}
			return true
		l92:
			position, tokenIndex = position92, tokenIndex92
			return false
		},
		/* 8 Args <- <(Arg (WS? ',' WS? Arg)*)> */
		func() bool {
			position110, tokenIndex110 := position, tokenIndex
			{
				position111 := position
				if !_rules[ruleArg]() {
					goto l110
				}
			l112:
				{
					position113, tokenIndex113 := position, tokenIndex
					{
						position114, tokenIndex114 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l114
						}
						goto l115
					l114:
						position, tokenIndex = position114, tokenIndex114
					}
				l115:
					if buffer[position] != rune(',') {
						goto l113
					}
					position++
					{
						position116, tokenIndex116 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l116
						}
						goto l117
					l116:
						position, tokenIndex = position116, tokenIndex116
					}
				l117:
					if !_rules[ruleArg]() {
						goto l113
					}
					goto l112
				l113:
					position, tokenIndex = position113, tokenIndex113
				}
				add(ruleArgs, position111)
			}
			return true
		l110:
			position, tokenIndex = position110, tokenIndex110
			return false
		},
		/* 9 Arg <- <(QuotedArg / ([0-9] / [0-9] / ([a-z] / [A-Z]) / '%' / '+' / '-' / '*' / '_' / '@' / '.')*)> */
		func() bool {
			{
				position119 := position
				{
					position120, tokenIndex120 := position, tokenIndex
					if !_rules[ruleQuotedArg]() {
						goto l121
					}
					goto l120
				l121:
					position, tokenIndex = position120, tokenIndex120
				l122:
					{
						position123, tokenIndex123 := position, tokenIndex
						{
							position124, tokenIndex124 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l125
							}
							position++
							goto l124
						l125:
							position, tokenIndex = position124, tokenIndex124
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l126
							}
							position++
							goto l124
						l126:
							position, tokenIndex = position124, tokenIndex124
							{
								position128, tokenIndex128 := position, tokenIndex
								if c := buffer[position]; c < rune('a') || c > rune('z') {
									goto l129
								}
								position++
								goto l128
							l129:
								position, tokenIndex = position128, tokenIndex128
								if c := buffer[position]; c < rune('A') || c > rune('Z') {
									goto l127
								}
								position++
							}
						l128:
							goto l124
						l127:
							position, tokenIndex = position124, tokenIndex124
							if buffer[position] != rune('%') {
								goto l130
							}
							position++
							goto l124
						l130:
							position, tokenIndex = position124, tokenIndex124
							if buffer[position] != rune('+') {
								goto l131
							}
							position++
							goto l124
						l131:
							position, tokenIndex = position124, tokenIndex124
							if buffer[position] != rune('-') {
								goto l132
							}
							position++
							goto l124
						l132:
							position, tokenIndex = position124, tokenIndex124
							if buffer[position] != rune('*') {
								goto l133
							}
							position++
							goto l124
						l133:
							position, tokenIndex = position124, tokenIndex124
							if buffer[position] != rune('_') {
								goto l134
							}
							position++
							goto l124
						l134:
							position, tokenIndex = position124, tokenIndex124
							if buffer[position] != rune('@') {
								goto l135
							}
							position++
							goto l124
						l135:
							position, tokenIndex = position124, tokenIndex124
							if buffer[position] != rune('.') {
								goto l123
							}
							position++
						}
					l124:
						goto l122
					l123:
						position, tokenIndex = position123, tokenIndex123
					}
				}
			l120:
				add(ruleArg, position119)
			}
			return true
		},
		/* 10 QuotedArg <- <('"' QuotedText '"')> */
		func() bool {
			position136, tokenIndex136 := position, tokenIndex
			{
				position137 := position
				if buffer[position] != rune('"') {
					goto l136
				}
				position++
				if !_rules[ruleQuotedText]() {
					goto l136
				}
				if buffer[position] != rune('"') {
					goto l136
				}
				position++
				add(ruleQuotedArg, position137)
			}
			return true
		l136:
			position, tokenIndex = position136, tokenIndex136
			return false
		},
		/* 11 QuotedText <- <(EscapedChar / (!'"' .))*> */
		func() bool {
			{
				position139 := position
			l140:
				{
					position141, tokenIndex141 := position, tokenIndex
					{
						position142, tokenIndex142 := position, tokenIndex
						if !_rules[ruleEscapedChar]() {
							goto l143
						}
						goto l142
					l143:
						position, tokenIndex = position142, tokenIndex142
						{
							position144, tokenIndex144 := position, tokenIndex
							if buffer[position] != rune('"') {
								goto l144
							}
							position++
							goto l141
						l144:
							position, tokenIndex = position144, tokenIndex144
						}
						if !matchDot() {
							goto l141
						}
					}
				l142:
					goto l140
				l141:
					position, tokenIndex = position141, tokenIndex141
				}
				add(ruleQuotedText, position139)
			}
			return true
		},
		/* 12 LabelContainingDirective <- <(LabelContainingDirectiveName WS SymbolArgs)> */
		func() bool {
			position145, tokenIndex145 := position, tokenIndex
			{
				position146 := position
				if !_rules[ruleLabelContainingDirectiveName]() {
					goto l145
				}
				if !_rules[ruleWS]() {
					goto l145
				}
				if !_rules[ruleSymbolArgs]() {
					goto l145
				}
				add(ruleLabelContainingDirective, position146)
			}
			return true
		l145:
			position, tokenIndex = position145, tokenIndex145
			return false
		},
		/* 13 LabelContainingDirectiveName <- <(('.' ('x' / 'X') ('w' / 'W') ('o' / 'O') ('r' / 'R') ('d' / 'D')) / ('.' ('w' / 'W') ('o' / 'O') ('r' / 'R') ('d' / 'D')) / ('.' ('l' / 'L') ('o' / 'O') ('n' / 'N') ('g' / 'G')) / ('.' ('s' / 'S') ('e' / 'E') ('t' / 'T')) / ('.' ('b' / 'B') ('y' / 'Y') ('t' / 'T') ('e' / 'E')) / ('.' '8' ('b' / 'B') ('y' / 'Y') ('t' / 'T') ('e' / 'E')) / ('.' '4' ('b' / 'B') ('y' / 'Y') ('t' / 'T') ('e' / 'E')) / ('.' ('q' / 'Q') ('u' / 'U') ('a' / 'A') ('d' / 'D')) / ('.' ('t' / 'T') ('c' / 'C')) / ('.' ('l' / 'L') ('o' / 'O') ('c' / 'C') ('a' / 'A') ('l' / 'L') ('e' / 'E') ('n' / 'N') ('t' / 'T') ('r' / 'R') ('y' / 'Y')) / ('.' ('s' / 'S') ('i' / 'I') ('z' / 'Z') ('e' / 'E')) / ('.' ('t' / 'T') ('y' / 'Y') ('p' / 'P') ('e' / 'E')) / ('.' ('u' / 'U') ('l' / 'L') ('e' / 'E') ('b' / 'B') '1' '2' '8') / ('.' ('s' / 'S') ('l' / 'L') ('e' / 'E') ('b' / 'B') '1' '2' '8'))> */
		func() bool {
			position147, tokenIndex147 := position, tokenIndex
			{
				position148 := position
				{
					position149, tokenIndex149 := position, tokenIndex
					if buffer[position] != rune('.') {
						goto l150
					}
					position++
					{
						position151, tokenIndex151 := position, tokenIndex
						if buffer[position] != rune('x') {
							goto l152
						}
						position++
						goto l151
					l152:
						position, tokenIndex = position151, tokenIndex151
						if buffer[position] != rune('X') {
							goto l150
						}
						position++
					}
				l151:
					{
						position153, tokenIndex153 := position, tokenIndex
						if buffer[position] != rune('w') {
							goto l154
						}
						position++
						goto l153
					l154:
						position, tokenIndex = position153, tokenIndex153
						if buffer[position] != rune('W') {
							goto l150
						}
						position++
					}
				l153:
					{
						position155, tokenIndex155 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l156
						}
						position++
						goto l155
					l156:
						position, tokenIndex = position155, tokenIndex155
						if buffer[position] != rune('O') {
							goto l150
						}
						position++
					}
				l155:
					{
						position157, tokenIndex157 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l158
						}
						position++
						goto l157
					l158:
						position, tokenIndex = position157, tokenIndex157
						if buffer[position] != rune('R') {
							goto l150
						}
						position++
					}
				l157:
					{
						position159, tokenIndex159 := position, tokenIndex
						if buffer[position] != rune('d') {
							goto l160
						}
						position++
						goto l159
					l160:
						position, tokenIndex = position159, tokenIndex159
						if buffer[position] != rune('D') {
							goto l150
						}
						position++
					}
				l159:
					goto l149
				l150:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l161
					}
					position++
					{
						position162, tokenIndex162 := position, tokenIndex
						if buffer[position] != rune('w') {
							goto l163
						}
						position++
						goto l162
					l163:
						position, tokenIndex = position162, tokenIndex162
						if buffer[position] != rune('W') {
							goto l161
						}
						position++
					}
				l162:
					{
						position164, tokenIndex164 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l165
						}
						position++
						goto l164
					l165:
						position, tokenIndex = position164, tokenIndex164
						if buffer[position] != rune('O') {
							goto l161
						}
						position++
					}
				l164:
					{
						position166, tokenIndex166 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l167
						}
						position++
						goto l166
					l167:
						position, tokenIndex = position166, tokenIndex166
						if buffer[position] != rune('R') {
							goto l161
						}
						position++
					}
				l166:
					{
						position168, tokenIndex168 := position, tokenIndex
						if buffer[position] != rune('d') {
							goto l169
						}
						position++
						goto l168
					l169:
						position, tokenIndex = position168, tokenIndex168
						if buffer[position] != rune('D') {
							goto l161
						}
						position++
					}
				l168:
					goto l149
				l161:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l170
					}
					position++
					{
						position171, tokenIndex171 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l172
						}
						position++
						goto l171
					l172:
						position, tokenIndex = position171, tokenIndex171
						if buffer[position] != rune('L') {
							goto l170
						}
						position++
					}
				l171:
					{
						position173, tokenIndex173 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l174
						}
						position++
						goto l173
					l174:
						position, tokenIndex = position173, tokenIndex173
						if buffer[position] != rune('O') {
							goto l170
						}
						position++
					}
				l173:
					{
						position175, tokenIndex175 := position, tokenIndex
						if buffer[position] != rune('n') {
							goto l176
						}
						position++
						goto l175
					l176:
						position, tokenIndex = position175, tokenIndex175
						if buffer[position] != rune('N') {
							goto l170
						}
						position++
					}
				l175:
					{
						position177, tokenIndex177 := position, tokenIndex
						if buffer[position] != rune('g') {
							goto l178
						}
						position++
						goto l177
					l178:
						position, tokenIndex = position177, tokenIndex177
						if buffer[position] != rune('G') {
							goto l170
						}
						position++
					}
				l177:
					goto l149
				l170:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l179
					}
					position++
					{
						position180, tokenIndex180 := position, tokenIndex
						if buffer[position] != rune('s') {
							goto l181
						}
						position++
						goto l180
					l181:
						position, tokenIndex = position180, tokenIndex180
						if buffer[position] != rune('S') {
							goto l179
						}
						position++
					}
				l180:
					{
						position182, tokenIndex182 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l183
						}
						position++
						goto l182
					l183:
						position, tokenIndex = position182, tokenIndex182
						if buffer[position] != rune('E') {
							goto l179
						}
						position++
					}
				l182:
					{
						position184, tokenIndex184 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l185
						}
						position++
						goto l184
					l185:
						position, tokenIndex = position184, tokenIndex184
						if buffer[position] != rune('T') {
							goto l179
						}
						position++
					}
				l184:
					goto l149
				l179:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l186
					}
					position++
					{
						position187, tokenIndex187 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l188
						}
						position++
						goto l187
					l188:
						position, tokenIndex = position187, tokenIndex187
						if buffer[position] != rune('B') {
							goto l186
						}
						position++
					}
				l187:
					{
						position189, tokenIndex189 := position, tokenIndex
						if buffer[position] != rune('y') {
							goto l190
						}
						position++
						goto l189
					l190:
						position, tokenIndex = position189, tokenIndex189
						if buffer[position] != rune('Y') {
							goto l186
						}
						position++
					}
				l189:
					{
						position191, tokenIndex191 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l192
						}
						position++
						goto l191
					l192:
						position, tokenIndex = position191, tokenIndex191
						if buffer[position] != rune('T') {
							goto l186
						}
						position++
					}
				l191:
					{
						position193, tokenIndex193 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l194
						}
						position++
						goto l193
					l194:
						position, tokenIndex = position193, tokenIndex193
						if buffer[position] != rune('E') {
							goto l186
						}
						position++
					}
				l193:
					goto l149
				l186:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l195
					}
					position++
					if buffer[position] != rune('8') {
						goto l195
					}
					position++
					{
						position196, tokenIndex196 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l197
						}
						position++
						goto l196
					l197:
						position, tokenIndex = position196, tokenIndex196
						if buffer[position] != rune('B') {
							goto l195
						}
						position++
					}
				l196:
					{
						position198, tokenIndex198 := position, tokenIndex
						if buffer[position] != rune('y') {
							goto l199
						}
						position++
						goto l198
					l199:
						position, tokenIndex = position198, tokenIndex198
						if buffer[position] != rune('Y') {
							goto l195
						}
						position++
					}
				l198:
					{
						position200, tokenIndex200 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l201
						}
						position++
						goto l200
					l201:
						position, tokenIndex = position200, tokenIndex200
						if buffer[position] != rune('T') {
							goto l195
						}
						position++
					}
				l200:
					{
						position202, tokenIndex202 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l203
						}
						position++
						goto l202
					l203:
						position, tokenIndex = position202, tokenIndex202
						if buffer[position] != rune('E') {
							goto l195
						}
						position++
					}
				l202:
					goto l149
				l195:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l204
					}
					position++
					if buffer[position] != rune('4') {
						goto l204
					}
					position++
					{
						position205, tokenIndex205 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l206
						}
						position++
						goto l205
					l206:
						position, tokenIndex = position205, tokenIndex205
						if buffer[position] != rune('B') {
							goto l204
						}
						position++
					}
				l205:
					{
						position207, tokenIndex207 := position, tokenIndex
						if buffer[position] != rune('y') {
							goto l208
						}
						position++
						goto l207
					l208:
						position, tokenIndex = position207, tokenIndex207
						if buffer[position] != rune('Y') {
							goto l204
						}
						position++
					}
				l207:
					{
						position209, tokenIndex209 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l210
						}
						position++
						goto l209
					l210:
						position, tokenIndex = position209, tokenIndex209
						if buffer[position] != rune('T') {
							goto l204
						}
						position++
					}
				l209:
					{
						position211, tokenIndex211 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l212
						}
						position++
						goto l211
					l212:
						position, tokenIndex = position211, tokenIndex211
						if buffer[position] != rune('E') {
							goto l204
						}
						position++
					}
				l211:
					goto l149
				l204:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l213
					}
					position++
					{
						position214, tokenIndex214 := position, tokenIndex
						if buffer[position] != rune('q') {
							goto l215
						}
						position++
						goto l214
					l215:
						position, tokenIndex = position214, tokenIndex214
						if buffer[position] != rune('Q') {
							goto l213
						}
						position++
					}
				l214:
					{
						position216, tokenIndex216 := position, tokenIndex
						if buffer[position] != rune('u') {
							goto l217
						}
						position++
						goto l216
					l217:
						position, tokenIndex = position216, tokenIndex216
						if buffer[position] != rune('U') {
							goto l213
						}
						position++
					}
				l216:
					{
						position218, tokenIndex218 := position, tokenIndex
						if buffer[position] != rune('a') {
							goto l219
						}
						position++
						goto l218
					l219:
						position, tokenIndex = position218, tokenIndex218
						if buffer[position] != rune('A') {
							goto l213
						}
						position++
					}
				l218:
					{
						position220, tokenIndex220 := position, tokenIndex
						if buffer[position] != rune('d') {
							goto l221
						}
						position++
						goto l220
					l221:
						position, tokenIndex = position220, tokenIndex220
						if buffer[position] != rune('D') {
							goto l213
						}
						position++
					}
				l220:
					goto l149
				l213:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l222
					}
					position++
					{
						position223, tokenIndex223 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l224
						}
						position++
						goto l223
					l224:
						position, tokenIndex = position223, tokenIndex223
						if buffer[position] != rune('T') {
							goto l222
						}
						position++
					}
				l223:
					{
						position225, tokenIndex225 := position, tokenIndex
						if buffer[position] != rune('c') {
							goto l226
						}
						position++
						goto l225
					l226:
						position, tokenIndex = position225, tokenIndex225
						if buffer[position] != rune('C') {
							goto l222
						}
						position++
					}
				l225:
					goto l149
				l222:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l227
					}
					position++
					{
						position228, tokenIndex228 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l229
						}
						position++
						goto l228
					l229:
						position, tokenIndex = position228, tokenIndex228
						if buffer[position] != rune('L') {
							goto l227
						}
						position++
					}
				l228:
					{
						position230, tokenIndex230 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l231
						}
						position++
						goto l230
					l231:
						position, tokenIndex = position230, tokenIndex230
						if buffer[position] != rune('O') {
							goto l227
						}
						position++
					}
				l230:
					{
						position232, tokenIndex232 := position, tokenIndex
						if buffer[position] != rune('c') {
							goto l233
						}
						position++
						goto l232
					l233:
						position, tokenIndex = position232, tokenIndex232
						if buffer[position] != rune('C') {
							goto l227
						}
						position++
					}
				l232:
					{
						position234, tokenIndex234 := position, tokenIndex
						if buffer[position] != rune('a') {
							goto l235
						}
						position++
						goto l234
					l235:
						position, tokenIndex = position234, tokenIndex234
						if buffer[position] != rune('A') {
							goto l227
						}
						position++
					}
				l234:
					{
						position236, tokenIndex236 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l237
						}
						position++
						goto l236
					l237:
						position, tokenIndex = position236, tokenIndex236
						if buffer[position] != rune('L') {
							goto l227
						}
						position++
					}
				l236:
					{
						position238, tokenIndex238 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l239
						}
						position++
						goto l238
					l239:
						position, tokenIndex = position238, tokenIndex238
						if buffer[position] != rune('E') {
							goto l227
						}
						position++
					}
				l238:
					{
						position240, tokenIndex240 := position, tokenIndex
						if buffer[position] != rune('n') {
							goto l241
						}
						position++
						goto l240
					l241:
						position, tokenIndex = position240, tokenIndex240
						if buffer[position] != rune('N') {
							goto l227
						}
						position++
					}
				l240:
					{
						position242, tokenIndex242 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l243
						}
						position++
						goto l242
					l243:
						position, tokenIndex = position242, tokenIndex242
						if buffer[position] != rune('T') {
							goto l227
						}
						position++
					}
				l242:
					{
						position244, tokenIndex244 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l245
						}
						position++
						goto l244
					l245:
						position, tokenIndex = position244, tokenIndex244
						if buffer[position] != rune('R') {
							goto l227
						}
						position++
					}
				l244:
					{
						position246, tokenIndex246 := position, tokenIndex
						if buffer[position] != rune('y') {
							goto l247
						}
						position++
						goto l246
					l247:
						position, tokenIndex = position246, tokenIndex246
						if buffer[position] != rune('Y') {
							goto l227
						}
						position++
					}
				l246:
					goto l149
				l227:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l248
					}
					position++
					{
						position249, tokenIndex249 := position, tokenIndex
						if buffer[position] != rune('s') {
							goto l250
						}
						position++
						goto l249
					l250:
						position, tokenIndex = position249, tokenIndex249
						if buffer[position] != rune('S') {
							goto l248
						}
						position++
					}
				l249:
					{
						position251, tokenIndex251 := position, tokenIndex
						if buffer[position] != rune('i') {
							goto l252
						}
						position++
						goto l251
					l252:
						position, tokenIndex = position251, tokenIndex251
						if buffer[position] != rune('I') {
							goto l248
						}
						position++
					}
				l251:
					{
						position253, tokenIndex253 := position, tokenIndex
						if buffer[position] != rune('z') {
							goto l254
						}
						position++
						goto l253
					l254:
						position, tokenIndex = position253, tokenIndex253
						if buffer[position] != rune('Z') {
							goto l248
						}
						position++
					}
				l253:
					{
						position255, tokenIndex255 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l256
						}
						position++
						goto l255
					l256:
						position, tokenIndex = position255, tokenIndex255
						if buffer[position] != rune('E') {
							goto l248
						}
						position++
					}
				l255:
					goto l149
				l248:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l257
					}
					position++
					{
						position258, tokenIndex258 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l259
						}
						position++
						goto l258
					l259:
						position, tokenIndex = position258, tokenIndex258
						if buffer[position] != rune('T') {
							goto l257
						}
						position++
					}
				l258:
					{
						position260, tokenIndex260 := position, tokenIndex
						if buffer[position] != rune('y') {
							goto l261
						}
						position++
						goto l260
					l261:
						position, tokenIndex = position260, tokenIndex260
						if buffer[position] != rune('Y') {
							goto l257
						}
						position++
					}
				l260:
					{
						position262, tokenIndex262 := position, tokenIndex
						if buffer[position] != rune('p') {
							goto l263
						}
						position++
						goto l262
					l263:
						position, tokenIndex = position262, tokenIndex262
						if buffer[position] != rune('P') {
							goto l257
						}
						position++
					}
				l262:
					{
						position264, tokenIndex264 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l265
						}
						position++
						goto l264
					l265:
						position, tokenIndex = position264, tokenIndex264
						if buffer[position] != rune('E') {
							goto l257
						}
						position++
					}
				l264:
					goto l149
				l257:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l266
					}
					position++
					{
						position267, tokenIndex267 := position, tokenIndex
						if buffer[position] != rune('u') {
							goto l268
						}
						position++
						goto l267
					l268:
						position, tokenIndex = position267, tokenIndex267
						if buffer[position] != rune('U') {
							goto l266
						}
						position++
					}
				l267:
					{
						position269, tokenIndex269 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l270
						}
						position++
						goto l269
					l270:
						position, tokenIndex = position269, tokenIndex269
						if buffer[position] != rune('L') {
							goto l266
						}
						position++
					}
				l269:
					{
						position271, tokenIndex271 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l272
						}
						position++
						goto l271
					l272:
						position, tokenIndex = position271, tokenIndex271
						if buffer[position] != rune('E') {
							goto l266
						}
						position++
					}
				l271:
					{
						position273, tokenIndex273 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l274
						}
						position++
						goto l273
					l274:
						position, tokenIndex = position273, tokenIndex273
						if buffer[position] != rune('B') {
							goto l266
						}
						position++
					}
				l273:
					if buffer[position] != rune('1') {
						goto l266
					}
					position++
					if buffer[position] != rune('2') {
						goto l266
					}
					position++
					if buffer[position] != rune('8') {
						goto l266
					}
					position++
					goto l149
				l266:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l147
					}
					position++
					{
						position275, tokenIndex275 := position, tokenIndex
						if buffer[position] != rune('s') {
							goto l276
						}
						position++
						goto l275
					l276:
						position, tokenIndex = position275, tokenIndex275
						if buffer[position] != rune('S') {
							goto l147
						}
						position++
					}
				l275:
					{
						position277, tokenIndex277 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l278
						}
						position++
						goto l277
					l278:
						position, tokenIndex = position277, tokenIndex277
						if buffer[position] != rune('L') {
							goto l147
						}
						position++
					}
				l277:
					{
						position279, tokenIndex279 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l280
						}
						position++
						goto l279
					l280:
						position, tokenIndex = position279, tokenIndex279
						if buffer[position] != rune('E') {
							goto l147
						}
						position++
					}
				l279:
					{
						position281, tokenIndex281 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l282
						}
						position++
						goto l281
					l282:
						position, tokenIndex = position281, tokenIndex281
						if buffer[position] != rune('B') {
							goto l147
						}
						position++
					}
				l281:
					if buffer[position] != rune('1') {
						goto l147
					}
					position++
					if buffer[position] != rune('2') {
						goto l147
					}
					position++
					if buffer[position] != rune('8') {
						goto l147
					}
					position++
				}
			l149:
				add(ruleLabelContainingDirectiveName, position148)
			}
			return true
		l147:
			position, tokenIndex = position147, tokenIndex147
			return false
		},
		/* 14 SymbolArgs <- <(SymbolArg (WS? ',' WS? SymbolArg)*)> */
		func() bool {
			position283, tokenIndex283 := position, tokenIndex
			{
				position284 := position
				if !_rules[ruleSymbolArg]() {
					goto l283
				}
			l285:
				{
					position286, tokenIndex286 := position, tokenIndex
					{
						position287, tokenIndex287 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l287
						}
						goto l288
					l287:
						position, tokenIndex = position287, tokenIndex287
					}
				l288:
					if buffer[position] != rune(',') {
						goto l286
					}
					position++
					{
						position289, tokenIndex289 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l289
						}
						goto l290
					l289:
						position, tokenIndex = position289, tokenIndex289
					}
				l290:
					if !_rules[ruleSymbolArg]() {
						goto l286
					}
					goto l285
				l286:
					position, tokenIndex = position286, tokenIndex286
				}
				add(ruleSymbolArgs, position284)
			}
			return true
		l283:
			position, tokenIndex = position283, tokenIndex283
			return false
		},
		/* 15 SymbolShift <- <((('<' '<') / ('>' '>')) WS? [0-9]+)> */
		func() bool {
			position291, tokenIndex291 := position, tokenIndex
			{
				position292 := position
				{
					position293, tokenIndex293 := position, tokenIndex
					if buffer[position] != rune('<') {
						goto l294
					}
					position++
					if buffer[position] != rune('<') {
						goto l294
					}
					position++
					goto l293
				l294:
					position, tokenIndex = position293, tokenIndex293
					if buffer[position] != rune('>') {
						goto l291
					}
					position++
					if buffer[position] != rune('>') {
						goto l291
					}
					position++
				}
			l293:
				{
					position295, tokenIndex295 := position, tokenIndex
					if !_rules[ruleWS]() {
						goto l295
					}
					goto l296
				l295:
					position, tokenIndex = position295, tokenIndex295
				}
			l296:
				if c := buffer[position]; c < rune('0') || c > rune('9') {
					goto l291
				}
				position++
			l297:
				{
					position298, tokenIndex298 := position, tokenIndex
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l298
					}
					position++
					goto l297
				l298:
					position, tokenIndex = position298, tokenIndex298
				}
				add(ruleSymbolShift, position292)
			}
			return true
		l291:
			position, tokenIndex = position291, tokenIndex291
			return false
		},
		/* 16 SymbolArg <- <((OpenParen WS?)? (Offset / SymbolType / ((Offset / LocalSymbol / SymbolName / Dot) (WS? Operator WS? (Offset / LocalSymbol / SymbolName))*) / (LocalLabelRef WS? Operator WS? LocalLabelRef) / (LocalSymbol TCMarker?) / (SymbolName Offset) / (SymbolName TCMarker?)) (WS? CloseParen)? (WS? SymbolShift)?)> */
		func() bool {
			position299, tokenIndex299 := position, tokenIndex
			{
				position300 := position
				{
					position301, tokenIndex301 := position, tokenIndex
					if !_rules[ruleOpenParen]() {
						goto l301
					}
					{
						position303, tokenIndex303 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l303
						}
						goto l304
					l303:
						position, tokenIndex = position303, tokenIndex303
					}
				l304:
					goto l302
				l301:
					position, tokenIndex = position301, tokenIndex301
				}
			l302:
				{
					position305, tokenIndex305 := position, tokenIndex
					if !_rules[ruleOffset]() {
						goto l306
					}
					goto l305
				l306:
					position, tokenIndex = position305, tokenIndex305
					if !_rules[ruleSymbolType]() {
						goto l307
					}
					goto l305
				l307:
					position, tokenIndex = position305, tokenIndex305
					{
						position309, tokenIndex309 := position, tokenIndex
						if !_rules[ruleOffset]() {
							goto l310
						}
						goto l309
					l310:
						position, tokenIndex = position309, tokenIndex309
						if !_rules[ruleLocalSymbol]() {
							goto l311
						}
						goto l309
					l311:
						position, tokenIndex = position309, tokenIndex309
						if !_rules[ruleSymbolName]() {
							goto l312
						}
						goto l309
					l312:
						position, tokenIndex = position309, tokenIndex309
						if !_rules[ruleDot]() {
							goto l308
						}
					}
				l309:
				l313:
					{
						position314, tokenIndex314 := position, tokenIndex
						{
							position315, tokenIndex315 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l315
							}
							goto l316
						l315:
							position, tokenIndex = position315, tokenIndex315
						}
					l316:
						if !_rules[ruleOperator]() {
							goto l314
						}
						{
							position317, tokenIndex317 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l317
							}
							goto l318
						l317:
							position, tokenIndex = position317, tokenIndex317
						}
					l318:
						{
							position319, tokenIndex319 := position, tokenIndex
							if !_rules[ruleOffset]() {
								goto l320
							}
							goto l319
						l320:
							position, tokenIndex = position319, tokenIndex319
							if !_rules[ruleLocalSymbol]() {
								goto l321
							}
							goto l319
						l321:
							position, tokenIndex = position319, tokenIndex319
							if !_rules[ruleSymbolName]() {
								goto l314
							}
						}
					l319:
						goto l313
					l314:
						position, tokenIndex = position314, tokenIndex314
					}
					goto l305
				l308:
					position, tokenIndex = position305, tokenIndex305
					if !_rules[ruleLocalLabelRef]() {
						goto l322
					}
					{
						position323, tokenIndex323 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l323
						}
						goto l324
					l323:
						position, tokenIndex = position323, tokenIndex323
					}
				l324:
					if !_rules[ruleOperator]() {
						goto l322
					}
					{
						position325, tokenIndex325 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l325
						}
						goto l326
					l325:
						position, tokenIndex = position325, tokenIndex325
					}
				l326:
					if !_rules[ruleLocalLabelRef]() {
						goto l322
					}
					goto l305
				l322:
					position, tokenIndex = position305, tokenIndex305
					if !_rules[ruleLocalSymbol]() {
						goto l327
					}
					{
						position328, tokenIndex328 := position, tokenIndex
						if !_rules[ruleTCMarker]() {
							goto l328
						}
						goto l329
					l328:
						position, tokenIndex = position328, tokenIndex328
					}
				l329:
					goto l305
				l327:
					position, tokenIndex = position305, tokenIndex305
					if !_rules[ruleSymbolName]() {
						goto l330
					}
					if !_rules[ruleOffset]() {
						goto l330
					}
					goto l305
				l330:
					position, tokenIndex = position305, tokenIndex305
					if !_rules[ruleSymbolName]() {
						goto l299
					}
					{
						position331, tokenIndex331 := position, tokenIndex
						if !_rules[ruleTCMarker]() {
							goto l331
						}
						goto l332
					l331:
						position, tokenIndex = position331, tokenIndex331
					}
				l332:
				}
			l305:
				{
					position333, tokenIndex333 := position, tokenIndex
					{
						position335, tokenIndex335 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l335
						}
						goto l336
					l335:
						position, tokenIndex = position335, tokenIndex335
					}
				l336:
					if !_rules[ruleCloseParen]() {
						goto l333
					}
					goto l334
				l333:
					position, tokenIndex = position333, tokenIndex333
				}
			l334:
				{
					position337, tokenIndex337 := position, tokenIndex
					{
						position339, tokenIndex339 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l339
						}
						goto l340
					l339:
						position, tokenIndex = position339, tokenIndex339
					}
				l340:
					if !_rules[ruleSymbolShift]() {
						goto l337
					}
					goto l338
				l337:
					position, tokenIndex = position337, tokenIndex337
				}
			l338:
				add(ruleSymbolArg, position300)
			}
			return true
		l299:
			position, tokenIndex = position299, tokenIndex299
			return false
		},
		/* 17 OpenParen <- <'('> */
		func() bool {
			position341, tokenIndex341 := position, tokenIndex
			{
				position342 := position
				if buffer[position] != rune('(') {
					goto l341
				}
				position++
				add(ruleOpenParen, position342)
			}
			return true
		l341:
			position, tokenIndex = position341, tokenIndex341
			return false
		},
		/* 18 CloseParen <- <')'> */
		func() bool {
			position343, tokenIndex343 := position, tokenIndex
			{
				position344 := position
				if buffer[position] != rune(')') {
					goto l343
				}
				position++
				add(ruleCloseParen, position344)
			}
			return true
		l343:
			position, tokenIndex = position343, tokenIndex343
			return false
		},
		/* 19 SymbolType <- <(('@' / '%') (('f' 'u' 'n' 'c' 't' 'i' 'o' 'n') / ('o' 'b' 'j' 'e' 'c' 't')))> */
		func() bool {
			position345, tokenIndex345 := position, tokenIndex
			{
				position346 := position
				{
					position347, tokenIndex347 := position, tokenIndex
					if buffer[position] != rune('@') {
						goto l348
					}
					position++
					goto l347
				l348:
					position, tokenIndex = position347, tokenIndex347
					if buffer[position] != rune('%') {
						goto l345
					}
					position++
				}
			l347:
				{
					position349, tokenIndex349 := position, tokenIndex
					if buffer[position] != rune('f') {
						goto l350
					}
					position++
					if buffer[position] != rune('u') {
						goto l350
					}
					position++
					if buffer[position] != rune('n') {
						goto l350
					}
					position++
					if buffer[position] != rune('c') {
						goto l350
					}
					position++
					if buffer[position] != rune('t') {
						goto l350
					}
					position++
					if buffer[position] != rune('i') {
						goto l350
					}
					position++
					if buffer[position] != rune('o') {
						goto l350
					}
					position++
					if buffer[position] != rune('n') {
						goto l350
					}
					position++
					goto l349
				l350:
					position, tokenIndex = position349, tokenIndex349
					if buffer[position] != rune('o') {
						goto l345
					}
					position++
					if buffer[position] != rune('b') {
						goto l345
					}
					position++
					if buffer[position] != rune('j') {
						goto l345
					}
					position++
					if buffer[position] != rune('e') {
						goto l345
					}
					position++
					if buffer[position] != rune('c') {
						goto l345
					}
					position++
					if buffer[position] != rune('t') {
						goto l345
					}
					position++
				}
			l349:
				add(ruleSymbolType, position346)
			}
			return true
		l345:
			position, tokenIndex = position345, tokenIndex345
			return false
		},
		/* 20 Dot <- <'.'> */
		func() bool {
			position351, tokenIndex351 := position, tokenIndex
			{
				position352 := position
				if buffer[position] != rune('.') {
					goto l351
				}
				position++
				add(ruleDot, position352)
			}
			return true
		l351:
			position, tokenIndex = position351, tokenIndex351
			return false
		},
		/* 21 TCMarker <- <('[' 'T' 'C' ']')> */
		func() bool {
			position353, tokenIndex353 := position, tokenIndex
			{
				position354 := position
				if buffer[position] != rune('[') {
					goto l353
				}
				position++
				if buffer[position] != rune('T') {
					goto l353
				}
				position++
				if buffer[position] != rune('C') {
					goto l353
				}
				position++
				if buffer[position] != rune(']') {
					goto l353
				}
				position++
				add(ruleTCMarker, position354)
			}
			return true
		l353:
			position, tokenIndex = position353, tokenIndex353
			return false
		},
		/* 22 EscapedChar <- <('\\' .)> */
		func() bool {
			position355, tokenIndex355 := position, tokenIndex
			{
				position356 := position
				if buffer[position] != rune('\\') {
					goto l355
				}
				position++
				if !matchDot() {
					goto l355
				}
				add(ruleEscapedChar, position356)
			}
			return true
		l355:
			position, tokenIndex = position355, tokenIndex355
			return false
		},
		/* 23 WS <- <(' ' / '\t')+> */
		func() bool {
			position357, tokenIndex357 := position, tokenIndex
			{
				position358 := position
				{
					position361, tokenIndex361 := position, tokenIndex
					if buffer[position] != rune(' ') {
						goto l362
					}
					position++
					goto l361
				l362:
					position, tokenIndex = position361, tokenIndex361
					if buffer[position] != rune('\t') {
						goto l357
					}
					position++
				}
			l361:
			l359:
				{
					position360, tokenIndex360 := position, tokenIndex
					{
						position363, tokenIndex363 := position, tokenIndex
						if buffer[position] != rune(' ') {
							goto l364
						}
						position++
						goto l363
					l364:
						position, tokenIndex = position363, tokenIndex363
						if buffer[position] != rune('\t') {
							goto l360
						}
						position++
					}
				l363:
					goto l359
				l360:
					position, tokenIndex = position360, tokenIndex360
				}
				add(ruleWS, position358)
			}
			return true
		l357:
			position, tokenIndex = position357, tokenIndex357
			return false
		},
		/* 24 Comment <- <((('/' '/') / '#') (!'\n' .)*)> */
		func() bool {
			position365, tokenIndex365 := position, tokenIndex
			{
				position366 := position
				{
					position367, tokenIndex367 := position, tokenIndex
					if buffer[position] != rune('/') {
						goto l368
					}
					position++
					if buffer[position] != rune('/') {
						goto l368
					}
					position++
					goto l367
				l368:
					position, tokenIndex = position367, tokenIndex367
					if buffer[position] != rune('#') {
						goto l365
					}
					position++
				}
			l367:
			l369:
				{
					position370, tokenIndex370 := position, tokenIndex
					{
						position371, tokenIndex371 := position, tokenIndex
						if buffer[position] != rune('\n') {
							goto l371
						}
						position++
						goto l370
					l371:
						position, tokenIndex = position371, tokenIndex371
					}
					if !matchDot() {
						goto l370
					}
					goto l369
				l370:
					position, tokenIndex = position370, tokenIndex370
				}
				add(ruleComment, position366)
			}
			return true
		l365:
			position, tokenIndex = position365, tokenIndex365
			return false
		},
		/* 25 Label <- <((LocalSymbol / LocalLabel / SymbolName) ':')> */
		func() bool {
			position372, tokenIndex372 := position, tokenIndex
			{
				position373 := position
				{
					position374, tokenIndex374 := position, tokenIndex
					if !_rules[ruleLocalSymbol]() {
						goto l375
					}
					goto l374
				l375:
					position, tokenIndex = position374, tokenIndex374
					if !_rules[ruleLocalLabel]() {
						goto l376
					}
					goto l374
				l376:
					position, tokenIndex = position374, tokenIndex374
					if !_rules[ruleSymbolName]() {
						goto l372
					}
				}
			l374:
				if buffer[position] != rune(':') {
					goto l372
				}
				position++
				add(ruleLabel, position373)
			}
			return true
		l372:
			position, tokenIndex = position372, tokenIndex372
			return false
		},
		/* 26 SymbolName <- <(([a-z] / [A-Z] / '.' / '_') ([a-z] / [A-Z] / '.' / ([0-9] / [0-9]) / '$' / '_')*)> */
		func() bool {
			position377, tokenIndex377 := position, tokenIndex
			{
				position378 := position
				{
					position379, tokenIndex379 := position, tokenIndex
					if c := buffer[position]; c < rune('a') || c > rune('z') {
						goto l380
					}
					position++
					goto l379
				l380:
					position, tokenIndex = position379, tokenIndex379
					if c := buffer[position]; c < rune('A') || c > rune('Z') {
						goto l381
					}
					position++
					goto l379
				l381:
					position, tokenIndex = position379, tokenIndex379
					if buffer[position] != rune('.') {
						goto l382
					}
					position++
					goto l379
				l382:
					position, tokenIndex = position379, tokenIndex379
					if buffer[position] != rune('_') {
						goto l377
					}
					position++
				}
			l379:
			l383:
				{
					position384, tokenIndex384 := position, tokenIndex
					{
						position385, tokenIndex385 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l386
						}
						position++
						goto l385
					l386:
						position, tokenIndex = position385, tokenIndex385
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l387
						}
						position++
						goto l385
					l387:
						position, tokenIndex = position385, tokenIndex385
						if buffer[position] != rune('.') {
							goto l388
						}
						position++
						goto l385
					l388:
						position, tokenIndex = position385, tokenIndex385
						{
							position390, tokenIndex390 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l391
							}
							position++
							goto l390
						l391:
							position, tokenIndex = position390, tokenIndex390
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l389
							}
							position++
						}
					l390:
						goto l385
					l389:
						position, tokenIndex = position385, tokenIndex385
						if buffer[position] != rune('$') {
							goto l392
						}
						position++
						goto l385
					l392:
						position, tokenIndex = position385, tokenIndex385
						if buffer[position] != rune('_') {
							goto l384
						}
						position++
					}
				l385:
					goto l383
				l384:
					position, tokenIndex = position384, tokenIndex384
				}
				add(ruleSymbolName, position378)
			}
			return true
		l377:
			position, tokenIndex = position377, tokenIndex377
			return false
		},
		/* 27 LocalSymbol <- <('.' 'L' ([a-z] / [A-Z] / ([a-z] / [A-Z]) / '.' / ([0-9] / [0-9]) / '$' / '_')+)> */
		func() bool {
			position393, tokenIndex393 := position, tokenIndex
			{
				position394 := position
				if buffer[position] != rune('.') {
					goto l393
				}
				position++
				if buffer[position] != rune('L') {
					goto l393
				}
				position++
				{
					position397, tokenIndex397 := position, tokenIndex
					if c := buffer[position]; c < rune('a') || c > rune('z') {
						goto l398
					}
					position++
					goto l397
				l398:
					position, tokenIndex = position397, tokenIndex397
					if c := buffer[position]; c < rune('A') || c > rune('Z') {
						goto l399
					}
					position++
					goto l397
				l399:
					position, tokenIndex = position397, tokenIndex397
					{
						position401, tokenIndex401 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l402
						}
						position++
						goto l401
					l402:
						position, tokenIndex = position401, tokenIndex401
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l400
						}
						position++
					}
				l401:
					goto l397
				l400:
					position, tokenIndex = position397, tokenIndex397
					if buffer[position] != rune('.') {
						goto l403
					}
					position++
					goto l397
				l403:
					position, tokenIndex = position397, tokenIndex397
					{
						position405, tokenIndex405 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l406
						}
						position++
						goto l405
					l406:
						position, tokenIndex = position405, tokenIndex405
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l404
						}
						position++
					}
				l405:
					goto l397
				l404:
					position, tokenIndex = position397, tokenIndex397
					if buffer[position] != rune('$') {
						goto l407
					}
					position++
					goto l397
				l407:
					position, tokenIndex = position397, tokenIndex397
					if buffer[position] != rune('_') {
						goto l393
					}
					position++
				}
			l397:
			l395:
				{
					position396, tokenIndex396 := position, tokenIndex
					{
						position408, tokenIndex408 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l409
						}
						position++
						goto l408
					l409:
						position, tokenIndex = position408, tokenIndex408
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l410
						}
						position++
						goto l408
					l410:
						position, tokenIndex = position408, tokenIndex408
						{
							position412, tokenIndex412 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l413
							}
							position++
							goto l412
						l413:
							position, tokenIndex = position412, tokenIndex412
							if c := buffer[position]; c < rune('A') || c > rune('Z') {
								goto l411
							}
							position++
						}
					l412:
						goto l408
					l411:
						position, tokenIndex = position408, tokenIndex408
						if buffer[position] != rune('.') {
							goto l414
						}
						position++
						goto l408
					l414:
						position, tokenIndex = position408, tokenIndex408
						{
							position416, tokenIndex416 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l417
							}
							position++
							goto l416
						l417:
							position, tokenIndex = position416, tokenIndex416
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l415
							}
							position++
						}
					l416:
						goto l408
					l415:
						position, tokenIndex = position408, tokenIndex408
						if buffer[position] != rune('$') {
							goto l418
						}
						position++
						goto l408
					l418:
						position, tokenIndex = position408, tokenIndex408
						if buffer[position] != rune('_') {
							goto l396
						}
						position++
					}
				l408:
					goto l395
				l396:
					position, tokenIndex = position396, tokenIndex396
				}
				add(ruleLocalSymbol, position394)
			}
			return true
		l393:
			position, tokenIndex = position393, tokenIndex393
			return false
		},
		/* 28 LocalLabel <- <([0-9] ([0-9] / '$')*)> */
		func() bool {
			position419, tokenIndex419 := position, tokenIndex
			{
				position420 := position
				if c := buffer[position]; c < rune('0') || c > rune('9') {
					goto l419
				}
				position++
			l421:
				{
					position422, tokenIndex422 := position, tokenIndex
					{
						position423, tokenIndex423 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l424
						}
						position++
						goto l423
					l424:
						position, tokenIndex = position423, tokenIndex423
						if buffer[position] != rune('$') {
							goto l422
						}
						position++
					}
				l423:
					goto l421
				l422:
					position, tokenIndex = position422, tokenIndex422
				}
				add(ruleLocalLabel, position420)
			}
			return true
		l419:
			position, tokenIndex = position419, tokenIndex419
			return false
		},
		/* 29 LocalLabelRef <- <([0-9] ([0-9] / '$')* ('b' / 'f'))> */
		func() bool {
			position425, tokenIndex425 := position, tokenIndex
			{
				position426 := position
				if c := buffer[position]; c < rune('0') || c > rune('9') {
					goto l425
				}
				position++
			l427:
				{
					position428, tokenIndex428 := position, tokenIndex
					{
						position429, tokenIndex429 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l430
						}
						position++
						goto l429
					l430:
						position, tokenIndex = position429, tokenIndex429
						if buffer[position] != rune('$') {
							goto l428
						}
						position++
					}
				l429:
					goto l427
				l428:
					position, tokenIndex = position428, tokenIndex428
				}
				{
					position431, tokenIndex431 := position, tokenIndex
					if buffer[position] != rune('b') {
						goto l432
					}
					position++
					goto l431
				l432:
					position, tokenIndex = position431, tokenIndex431
					if buffer[position] != rune('f') {
						goto l425
					}
					position++
				}
			l431:
				add(ruleLocalLabelRef, position426)
			}
			return true
		l425:
			position, tokenIndex = position425, tokenIndex425
			return false
		},
		/* 30 Instruction <- <(InstructionName (WS InstructionArg (WS? ','? WS? InstructionArg)*)?)> */
		func() bool {
			position433, tokenIndex433 := position, tokenIndex
			{
				position434 := position
				if !_rules[ruleInstructionName]() {
					goto l433
				}
				{
					position435, tokenIndex435 := position, tokenIndex
					if !_rules[ruleWS]() {
						goto l435
					}
					if !_rules[ruleInstructionArg]() {
						goto l435
					}
				l437:
					{
						position438, tokenIndex438 := position, tokenIndex
						{
							position439, tokenIndex439 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l439
							}
							goto l440
						l439:
							position, tokenIndex = position439, tokenIndex439
						}
					l440:
						{
							position441, tokenIndex441 := position, tokenIndex
							if buffer[position] != rune(',') {
								goto l441
							}
							position++
							goto l442
						l441:
							position, tokenIndex = position441, tokenIndex441
						}
					l442:
						{
							position443, tokenIndex443 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l443
							}
							goto l444
						l443:
							position, tokenIndex = position443, tokenIndex443
						}
					l444:
						if !_rules[ruleInstructionArg]() {
							goto l438
						}
						goto l437
					l438:
						position, tokenIndex = position438, tokenIndex438
					}
					goto l436
				l435:
					position, tokenIndex = position435, tokenIndex435
				}
			l436:
				add(ruleInstruction, position434)
			}
			return true
		l433:
			position, tokenIndex = position433, tokenIndex433
			return false
		},
		/* 31 InstructionName <- <(([a-z] / [A-Z]) ([a-z] / [A-Z] / '.' / ([0-9] / [0-9]))* ('.' / '+' / '-')?)> */
		func() bool {
			position445, tokenIndex445 := position, tokenIndex
			{
				position446 := position
				{
					position447, tokenIndex447 := position, tokenIndex
					if c := buffer[position]; c < rune('a') || c > rune('z') {
						goto l448
					}
					position++
					goto l447
				l448:
					position, tokenIndex = position447, tokenIndex447
					if c := buffer[position]; c < rune('A') || c > rune('Z') {
						goto l445
					}
					position++
				}
			l447:
			l449:
				{
					position450, tokenIndex450 := position, tokenIndex
					{
						position451, tokenIndex451 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l452
						}
						position++
						goto l451
					l452:
						position, tokenIndex = position451, tokenIndex451
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l453
						}
						position++
						goto l451
					l453:
						position, tokenIndex = position451, tokenIndex451
						if buffer[position] != rune('.') {
							goto l454
						}
						position++
						goto l451
					l454:
						position, tokenIndex = position451, tokenIndex451
						{
							position455, tokenIndex455 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l456
							}
							position++
							goto l455
						l456:
							position, tokenIndex = position455, tokenIndex455
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l450
							}
							position++
						}
					l455:
					}
				l451:
					goto l449
				l450:
					position, tokenIndex = position450, tokenIndex450
				}
				{
					position457, tokenIndex457 := position, tokenIndex
					{
						position459, tokenIndex459 := position, tokenIndex
						if buffer[position] != rune('.') {
							goto l460
						}
						position++
						goto l459
					l460:
						position, tokenIndex = position459, tokenIndex459
						if buffer[position] != rune('+') {
							goto l461
						}
						position++
						goto l459
					l461:
						position, tokenIndex = position459, tokenIndex459
						if buffer[position] != rune('-') {
							goto l457
						}
						position++
					}
				l459:
					goto l458
				l457:
					position, tokenIndex = position457, tokenIndex457
				}
			l458:
				add(ruleInstructionName, position446)
			}
			return true
		l445:
			position, tokenIndex = position445, tokenIndex445
			return false
		},
		/* 32 InstructionArg <- <(IndirectionIndicator? (ARMConstantTweak / RegisterOrConstant / LocalLabelRef / TOCRefHigh / TOCRefLow / GOTLocation / GOTSymbolOffset / MemoryRef) AVX512Token*)> */
		func() bool {
			position462, tokenIndex462 := position, tokenIndex
			{
				position463 := position
				{
					position464, tokenIndex464 := position, tokenIndex
					if !_rules[ruleIndirectionIndicator]() {
						goto l464
					}
					goto l465
				l464:
					position, tokenIndex = position464, tokenIndex464
				}
			l465:
				{
					position466, tokenIndex466 := position, tokenIndex
					if !_rules[ruleARMConstantTweak]() {
						goto l467
					}
					goto l466
				l467:
					position, tokenIndex = position466, tokenIndex466
					if !_rules[ruleRegisterOrConstant]() {
						goto l468
					}
					goto l466
				l468:
					position, tokenIndex = position466, tokenIndex466
					if !_rules[ruleLocalLabelRef]() {
						goto l469
					}
					goto l466
				l469:
					position, tokenIndex = position466, tokenIndex466
					if !_rules[ruleTOCRefHigh]() {
						goto l470
					}
					goto l466
				l470:
					position, tokenIndex = position466, tokenIndex466
					if !_rules[ruleTOCRefLow]() {
						goto l471
					}
					goto l466
				l471:
					position, tokenIndex = position466, tokenIndex466
					if !_rules[ruleGOTLocation]() {
						goto l472
					}
					goto l466
				l472:
					position, tokenIndex = position466, tokenIndex466
					if !_rules[ruleGOTSymbolOffset]() {
						goto l473
					}
					goto l466
				l473:
					position, tokenIndex = position466, tokenIndex466
					if !_rules[ruleMemoryRef]() {
						goto l462
					}
				}
			l466:
			l474:
				{
					position475, tokenIndex475 := position, tokenIndex
					if !_rules[ruleAVX512Token]() {
						goto l475
					}
					goto l474
				l475:
					position, tokenIndex = position475, tokenIndex475
				}
				add(ruleInstructionArg, position463)
			}
			return true
		l462:
			position, tokenIndex = position462, tokenIndex462
			return false
		},
		/* 33 GOTLocation <- <('$' '_' 'G' 'L' 'O' 'B' 'A' 'L' '_' 'O' 'F' 'F' 'S' 'E' 'T' '_' 'T' 'A' 'B' 'L' 'E' '_' '-' LocalSymbol)> */
		func() bool {
			position476, tokenIndex476 := position, tokenIndex
			{
				position477 := position
				if buffer[position] != rune('$') {
					goto l476
				}
				position++
				if buffer[position] != rune('_') {
					goto l476
				}
				position++
				if buffer[position] != rune('G') {
					goto l476
				}
				position++
				if buffer[position] != rune('L') {
					goto l476
				}
				position++
				if buffer[position] != rune('O') {
					goto l476
				}
				position++
				if buffer[position] != rune('B') {
					goto l476
				}
				position++
				if buffer[position] != rune('A') {
					goto l476
				}
				position++
				if buffer[position] != rune('L') {
					goto l476
				}
				position++
				if buffer[position] != rune('_') {
					goto l476
				}
				position++
				if buffer[position] != rune('O') {
					goto l476
				}
				position++
				if buffer[position] != rune('F') {
					goto l476
				}
				position++
				if buffer[position] != rune('F') {
					goto l476
				}
				position++
				if buffer[position] != rune('S') {
					goto l476
				}
				position++
				if buffer[position] != rune('E') {
					goto l476
				}
				position++
				if buffer[position] != rune('T') {
					goto l476
				}
				position++
				if buffer[position] != rune('_') {
					goto l476
				}
				position++
				if buffer[position] != rune('T') {
					goto l476
				}
				position++
				if buffer[position] != rune('A') {
					goto l476
				}
				position++
				if buffer[position] != rune('B') {
					goto l476
				}
				position++
				if buffer[position] != rune('L') {
					goto l476
				}
				position++
				if buffer[position] != rune('E') {
					goto l476
				}
				position++
				if buffer[position] != rune('_') {
					goto l476
				}
				position++
				if buffer[position] != rune('-') {
					goto l476
				}
				position++
				if !_rules[ruleLocalSymbol]() {
					goto l476
				}
				add(ruleGOTLocation, position477)
			}
			return true
		l476:
			position, tokenIndex = position476, tokenIndex476
			return false
		},
		/* 34 GOTSymbolOffset <- <(('$' SymbolName ('@' 'G' 'O' 'T') ('O' 'F' 'F')?) / (':' ('g' / 'G') ('o' / 'O') ('t' / 'T') ':' SymbolName))> */
		func() bool {
			position478, tokenIndex478 := position, tokenIndex
			{
				position479 := position
				{
					position480, tokenIndex480 := position, tokenIndex
					if buffer[position] != rune('$') {
						goto l481
					}
					position++
					if !_rules[ruleSymbolName]() {
						goto l481
					}
					if buffer[position] != rune('@') {
						goto l481
					}
					position++
					if buffer[position] != rune('G') {
						goto l481
					}
					position++
					if buffer[position] != rune('O') {
						goto l481
					}
					position++
					if buffer[position] != rune('T') {
						goto l481
					}
					position++
					{
						position482, tokenIndex482 := position, tokenIndex
						if buffer[position] != rune('O') {
							goto l482
						}
						position++
						if buffer[position] != rune('F') {
							goto l482
						}
						position++
						if buffer[position] != rune('F') {
							goto l482
						}
						position++
						goto l483
					l482:
						position, tokenIndex = position482, tokenIndex482
					}
				l483:
					goto l480
				l481:
					position, tokenIndex = position480, tokenIndex480
					if buffer[position] != rune(':') {
						goto l478
					}
					position++
					{
						position484, tokenIndex484 := position, tokenIndex
						if buffer[position] != rune('g') {
							goto l485
						}
						position++
						goto l484
					l485:
						position, tokenIndex = position484, tokenIndex484
						if buffer[position] != rune('G') {
							goto l478
						}
						position++
					}
				l484:
					{
						position486, tokenIndex486 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l487
						}
						position++
						goto l486
					l487:
						position, tokenIndex = position486, tokenIndex486
						if buffer[position] != rune('O') {
							goto l478
						}
						position++
					}
				l486:
					{
						position488, tokenIndex488 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l489
						}
						position++
						goto l488
					l489:
						position, tokenIndex = position488, tokenIndex488
						if buffer[position] != rune('T') {
							goto l478
						}
						position++
					}
				l488:
					if buffer[position] != rune(':') {
						goto l478
					}
					position++
					if !_rules[ruleSymbolName]() {
						goto l478
					}
				}
			l480:
				add(ruleGOTSymbolOffset, position479)
			}
			return true
		l478:
			position, tokenIndex = position478, tokenIndex478
			return false
		},
		/* 35 AVX512Token <- <(WS? '{' '%'? ([0-9] / [a-z])* '}')> */
		func() bool {
			position490, tokenIndex490 := position, tokenIndex
			{
				position491 := position
				{
					position492, tokenIndex492 := position, tokenIndex
					if !_rules[ruleWS]() {
						goto l492
					}
					goto l493
				l492:
					position, tokenIndex = position492, tokenIndex492
				}
			l493:
				if buffer[position] != rune('{') {
					goto l490
				}
				position++
				{
					position494, tokenIndex494 := position, tokenIndex
					if buffer[position] != rune('%') {
						goto l494
					}
					position++
					goto l495
				l494:
					position, tokenIndex = position494, tokenIndex494
				}
			l495:
			l496:
				{
					position497, tokenIndex497 := position, tokenIndex
					{
						position498, tokenIndex498 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l499
						}
						position++
						goto l498
					l499:
						position, tokenIndex = position498, tokenIndex498
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l497
						}
						position++
					}
				l498:
					goto l496
				l497:
					position, tokenIndex = position497, tokenIndex497
				}
				if buffer[position] != rune('}') {
					goto l490
				}
				position++
				add(ruleAVX512Token, position491)
			}
			return true
		l490:
			position, tokenIndex = position490, tokenIndex490
			return false
		},
		/* 36 TOCRefHigh <- <('.' 'T' 'O' 'C' '.' '-' (('0' 'b') / ('.' 'L' ([a-z] / [A-Z] / '_' / [0-9])+)) ('@' ('h' / 'H') ('a' / 'A')))> */
		func() bool {
			position500, tokenIndex500 := position, tokenIndex
			{
				position501 := position
				if buffer[position] != rune('.') {
					goto l500
				}
				position++
				if buffer[position] != rune('T') {
					goto l500
				}
				position++
				if buffer[position] != rune('O') {
					goto l500
				}
				position++
				if buffer[position] != rune('C') {
					goto l500
				}
				position++
				if buffer[position] != rune('.') {
					goto l500
				}
				position++
				if buffer[position] != rune('-') {
					goto l500
				}
				position++
				{
					position502, tokenIndex502 := position, tokenIndex
					if buffer[position] != rune('0') {
						goto l503
					}
					position++
					if buffer[position] != rune('b') {
						goto l503
					}
					position++
					goto l502
				l503:
					position, tokenIndex = position502, tokenIndex502
					if buffer[position] != rune('.') {
						goto l500
					}
					position++
					if buffer[position] != rune('L') {
						goto l500
					}
					position++
					{
						position506, tokenIndex506 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l507
						}
						position++
						goto l506
					l507:
						position, tokenIndex = position506, tokenIndex506
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l508
						}
						position++
						goto l506
					l508:
						position, tokenIndex = position506, tokenIndex506
						if buffer[position] != rune('_') {
							goto l509
						}
						position++
						goto l506
					l509:
						position, tokenIndex = position506, tokenIndex506
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l500
						}
						position++
					}
				l506:
				l504:
					{
						position505, tokenIndex505 := position, tokenIndex
						{
							position510, tokenIndex510 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l511
							}
							position++
							goto l510
						l511:
							position, tokenIndex = position510, tokenIndex510
							if c := buffer[position]; c < rune('A') || c > rune('Z') {
								goto l512
							}
							position++
							goto l510
						l512:
							position, tokenIndex = position510, tokenIndex510
							if buffer[position] != rune('_') {
								goto l513
							}
							position++
							goto l510
						l513:
							position, tokenIndex = position510, tokenIndex510
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l505
							}
							position++
						}
					l510:
						goto l504
					l505:
						position, tokenIndex = position505, tokenIndex505
					}
				}
			l502:
				if buffer[position] != rune('@') {
					goto l500
				}
				position++
				{
					position514, tokenIndex514 := position, tokenIndex
					if buffer[position] != rune('h') {
						goto l515
					}
					position++
					goto l514
				l515:
					position, tokenIndex = position514, tokenIndex514
					if buffer[position] != rune('H') {
						goto l500
					}
					position++
				}
			l514:
				{
					position516, tokenIndex516 := position, tokenIndex
					if buffer[position] != rune('a') {
						goto l517
					}
					position++
					goto l516
				l517:
					position, tokenIndex = position516, tokenIndex516
					if buffer[position] != rune('A') {
						goto l500
					}
					position++
				}
			l516:
				add(ruleTOCRefHigh, position501)
			}
			return true
		l500:
			position, tokenIndex = position500, tokenIndex500
			return false
		},
		/* 37 TOCRefLow <- <('.' 'T' 'O' 'C' '.' '-' (('0' 'b') / ('.' 'L' ([a-z] / [A-Z] / '_' / [0-9])+)) ('@' ('l' / 'L')))> */
		func() bool {
			position518, tokenIndex518 := position, tokenIndex
			{
				position519 := position
				if buffer[position] != rune('.') {
					goto l518
				}
				position++
				if buffer[position] != rune('T') {
					goto l518
				}
				position++
				if buffer[position] != rune('O') {
					goto l518
				}
				position++
				if buffer[position] != rune('C') {
					goto l518
				}
				position++
				if buffer[position] != rune('.') {
					goto l518
				}
				position++
				if buffer[position] != rune('-') {
					goto l518
				}
				position++
				{
					position520, tokenIndex520 := position, tokenIndex
					if buffer[position] != rune('0') {
						goto l521
					}
					position++
					if buffer[position] != rune('b') {
						goto l521
					}
					position++
					goto l520
				l521:
					position, tokenIndex = position520, tokenIndex520
					if buffer[position] != rune('.') {
						goto l518
					}
					position++
					if buffer[position] != rune('L') {
						goto l518
					}
					position++
					{
						position524, tokenIndex524 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l525
						}
						position++
						goto l524
					l525:
						position, tokenIndex = position524, tokenIndex524
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l526
						}
						position++
						goto l524
					l526:
						position, tokenIndex = position524, tokenIndex524
						if buffer[position] != rune('_') {
							goto l527
						}
						position++
						goto l524
					l527:
						position, tokenIndex = position524, tokenIndex524
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l518
						}
						position++
					}
				l524:
				l522:
					{
						position523, tokenIndex523 := position, tokenIndex
						{
							position528, tokenIndex528 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l529
							}
							position++
							goto l528
						l529:
							position, tokenIndex = position528, tokenIndex528
							if c := buffer[position]; c < rune('A') || c > rune('Z') {
								goto l530
							}
							position++
							goto l528
						l530:
							position, tokenIndex = position528, tokenIndex528
							if buffer[position] != rune('_') {
								goto l531
							}
							position++
							goto l528
						l531:
							position, tokenIndex = position528, tokenIndex528
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l523
							}
							position++
						}
					l528:
						goto l522
					l523:
						position, tokenIndex = position523, tokenIndex523
					}
				}
			l520:
				if buffer[position] != rune('@') {
					goto l518
				}
				position++
				{
					position532, tokenIndex532 := position, tokenIndex
					if buffer[position] != rune('l') {
						goto l533
					}
					position++
					goto l532
				l533:
					position, tokenIndex = position532, tokenIndex532
					if buffer[position] != rune('L') {
						goto l518
					}
					position++
				}
			l532:
				add(ruleTOCRefLow, position519)
			}
			return true
		l518:
			position, tokenIndex = position518, tokenIndex518
			return false
		},
		/* 38 IndirectionIndicator <- <'*'> */
		func() bool {
			position534, tokenIndex534 := position, tokenIndex
			{
				position535 := position
				if buffer[position] != rune('*') {
					goto l534
				}
				position++
				add(ruleIndirectionIndicator, position535)
			}
			return true
		l534:
			position, tokenIndex = position534, tokenIndex534
			return false
		},
		/* 39 RegisterOrConstant <- <((('%' ([a-z] / [A-Z]) ([a-z] / [A-Z] / ([0-9] / [0-9]))*) / ('$' [0-9]+ WS? '*' WS? '(' [0-9]+ WS? '-' WS? [0-9]+ ')') / ('$'? ((Offset Offset) / Offset)) / ('#' Offset ('*' [0-9]+ ('-' [0-9] [0-9]*)?)?) / ('#' '~'? '(' [0-9] WS? ('<' '<') WS? [0-9] [0-9]? ')') / (('#' / '$') '~'? ('0' 'x')? ([0-9] / [0-9] / ([a-f] / [A-F]))+) / ('$' '(' '-' [0-9]+ ')') / ARMRegister) !('f' / 'b' / ':' / '(' / '+' / '-'))> */
		func() bool {
			position536, tokenIndex536 := position, tokenIndex
			{
				position537 := position
				{
					position538, tokenIndex538 := position, tokenIndex
					if buffer[position] != rune('%') {
						goto l539
					}
					position++
					{
						position540, tokenIndex540 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l541
						}
						position++
						goto l540
					l541:
						position, tokenIndex = position540, tokenIndex540
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l539
						}
						position++
					}
				l540:
				l542:
					{
						position543, tokenIndex543 := position, tokenIndex
						{
							position544, tokenIndex544 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l545
							}
							position++
							goto l544
						l545:
							position, tokenIndex = position544, tokenIndex544
							if c := buffer[position]; c < rune('A') || c > rune('Z') {
								goto l546
							}
							position++
							goto l544
						l546:
							position, tokenIndex = position544, tokenIndex544
							{
								position547, tokenIndex547 := position, tokenIndex
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l548
								}
								position++
								goto l547
							l548:
								position, tokenIndex = position547, tokenIndex547
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l543
								}
								position++
							}
						l547:
						}
					l544:
						goto l542
					l543:
						position, tokenIndex = position543, tokenIndex543
					}
					goto l538
				l539:
					position, tokenIndex = position538, tokenIndex538
					if buffer[position] != rune('$') {
						goto l549
					}
					position++
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l549
					}
					position++
				l550:
					{
						position551, tokenIndex551 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l551
						}
						position++
						goto l550
					l551:
						position, tokenIndex = position551, tokenIndex551
					}
					{
						position552, tokenIndex552 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l552
						}
						goto l553
					l552:
						position, tokenIndex = position552, tokenIndex552
					}
				l553:
					if buffer[position] != rune('*') {
						goto l549
					}
					position++
					{
						position554, tokenIndex554 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l554
						}
						goto l555
					l554:
						position, tokenIndex = position554, tokenIndex554
					}
				l555:
					if buffer[position] != rune('(') {
						goto l549
					}
					position++
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l549
					}
					position++
				l556:
					{
						position557, tokenIndex557 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l557
						}
						position++
						goto l556
					l557:
						position, tokenIndex = position557, tokenIndex557
					}
					{
						position558, tokenIndex558 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l558
						}
						goto l559
					l558:
						position, tokenIndex = position558, tokenIndex558
					}
				l559:
					if buffer[position] != rune('-') {
						goto l549
					}
					position++
					{
						position560, tokenIndex560 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l560
						}
						goto l561
					l560:
						position, tokenIndex = position560, tokenIndex560
					}
				l561:
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l549
					}
					position++
				l562:
					{
						position563, tokenIndex563 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l563
						}
						position++
						goto l562
					l563:
						position, tokenIndex = position563, tokenIndex563
					}
					if buffer[position] != rune(')') {
						goto l549
					}
					position++
					goto l538
				l549:
					position, tokenIndex = position538, tokenIndex538
					{
						position565, tokenIndex565 := position, tokenIndex
						if buffer[position] != rune('$') {
							goto l565
						}
						position++
						goto l566
					l565:
						position, tokenIndex = position565, tokenIndex565
					}
				l566:
					{
						position567, tokenIndex567 := position, tokenIndex
						if !_rules[ruleOffset]() {
							goto l568
						}
						if !_rules[ruleOffset]() {
							goto l568
						}
						goto l567
					l568:
						position, tokenIndex = position567, tokenIndex567
						if !_rules[ruleOffset]() {
							goto l564
						}
					}
				l567:
					goto l538
				l564:
					position, tokenIndex = position538, tokenIndex538
					if buffer[position] != rune('#') {
						goto l569
					}
					position++
					if !_rules[ruleOffset]() {
						goto l569
					}
					{
						position570, tokenIndex570 := position, tokenIndex
						if buffer[position] != rune('*') {
							goto l570
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l570
						}
						position++
					l572:
						{
							position573, tokenIndex573 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l573
							}
							position++
							goto l572
						l573:
							position, tokenIndex = position573, tokenIndex573
						}
						{
							position574, tokenIndex574 := position, tokenIndex
							if buffer[position] != rune('-') {
								goto l574
							}
							position++
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l574
							}
							position++
						l576:
							{
								position577, tokenIndex577 := position, tokenIndex
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l577
								}
								position++
								goto l576
							l577:
								position, tokenIndex = position577, tokenIndex577
							}
							goto l575
						l574:
							position, tokenIndex = position574, tokenIndex574
						}
					l575:
						goto l571
					l570:
						position, tokenIndex = position570, tokenIndex570
					}
				l571:
					goto l538
				l569:
					position, tokenIndex = position538, tokenIndex538
					if buffer[position] != rune('#') {
						goto l578
					}
					position++
					{
						position579, tokenIndex579 := position, tokenIndex
						if buffer[position] != rune('~') {
							goto l579
						}
						position++
						goto l580
					l579:
						position, tokenIndex = position579, tokenIndex579
					}
				l580:
					if buffer[position] != rune('(') {
						goto l578
					}
					position++
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l578
					}
					position++
					{
						position581, tokenIndex581 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l581
						}
						goto l582
					l581:
						position, tokenIndex = position581, tokenIndex581
					}
				l582:
					if buffer[position] != rune('<') {
						goto l578
					}
					position++
					if buffer[position] != rune('<') {
						goto l578
					}
					position++
					{
						position583, tokenIndex583 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l583
						}
						goto l584
					l583:
						position, tokenIndex = position583, tokenIndex583
					}
				l584:
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l578
					}
					position++
					{
						position585, tokenIndex585 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l585
						}
						position++
						goto l586
					l585:
						position, tokenIndex = position585, tokenIndex585
					}
				l586:
					if buffer[position] != rune(')') {
						goto l578
					}
					position++
					goto l538
				l578:
					position, tokenIndex = position538, tokenIndex538
					{
						position588, tokenIndex588 := position, tokenIndex
						if buffer[position] != rune('#') {
							goto l589
						}
						position++
						goto l588
					l589:
						position, tokenIndex = position588, tokenIndex588
						if buffer[position] != rune('$') {
							goto l587
						}
						position++
					}
				l588:
					{
						position590, tokenIndex590 := position, tokenIndex
						if buffer[position] != rune('~') {
							goto l590
						}
						position++
						goto l591
					l590:
						position, tokenIndex = position590, tokenIndex590
					}
				l591:
					{
						position592, tokenIndex592 := position, tokenIndex
						if buffer[position] != rune('0') {
							goto l592
						}
						position++
						if buffer[position] != rune('x') {
							goto l592
						}
						position++
						goto l593
					l592:
						position, tokenIndex = position592, tokenIndex592
					}
				l593:
					{
						position596, tokenIndex596 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l597
						}
						position++
						goto l596
					l597:
						position, tokenIndex = position596, tokenIndex596
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l598
						}
						position++
						goto l596
					l598:
						position, tokenIndex = position596, tokenIndex596
						{
							position599, tokenIndex599 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('f') {
								goto l600
							}
							position++
							goto l599
						l600:
							position, tokenIndex = position599, tokenIndex599
							if c := buffer[position]; c < rune('A') || c > rune('F') {
								goto l587
							}
							position++
						}
					l599:
					}
				l596:
				l594:
					{
						position595, tokenIndex595 := position, tokenIndex
						{
							position601, tokenIndex601 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l602
							}
							position++
							goto l601
						l602:
							position, tokenIndex = position601, tokenIndex601
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l603
							}
							position++
							goto l601
						l603:
							position, tokenIndex = position601, tokenIndex601
							{
								position604, tokenIndex604 := position, tokenIndex
								if c := buffer[position]; c < rune('a') || c > rune('f') {
									goto l605
								}
								position++
								goto l604
							l605:
								position, tokenIndex = position604, tokenIndex604
								if c := buffer[position]; c < rune('A') || c > rune('F') {
									goto l595
								}
								position++
							}
						l604:
						}
					l601:
						goto l594
					l595:
						position, tokenIndex = position595, tokenIndex595
					}
					goto l538
				l587:
					position, tokenIndex = position538, tokenIndex538
					if buffer[position] != rune('$') {
						goto l606
					}
					position++
					if buffer[position] != rune('(') {
						goto l606
					}
					position++
					if buffer[position] != rune('-') {
						goto l606
					}
					position++
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l606
					}
					position++
				l607:
					{
						position608, tokenIndex608 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l608
						}
						position++
						goto l607
					l608:
						position, tokenIndex = position608, tokenIndex608
					}
					if buffer[position] != rune(')') {
						goto l606
					}
					position++
					goto l538
				l606:
					position, tokenIndex = position538, tokenIndex538
					if !_rules[ruleARMRegister]() {
						goto l536
					}
				}
			l538:
				{
					position609, tokenIndex609 := position, tokenIndex
					{
						position610, tokenIndex610 := position, tokenIndex
						if buffer[position] != rune('f') {
							goto l611
						}
						position++
						goto l610
					l611:
						position, tokenIndex = position610, tokenIndex610
						if buffer[position] != rune('b') {
							goto l612
						}
						position++
						goto l610
					l612:
						position, tokenIndex = position610, tokenIndex610
						if buffer[position] != rune(':') {
							goto l613
						}
						position++
						goto l610
					l613:
						position, tokenIndex = position610, tokenIndex610
						if buffer[position] != rune('(') {
							goto l614
						}
						position++
						goto l610
					l614:
						position, tokenIndex = position610, tokenIndex610
						if buffer[position] != rune('+') {
							goto l615
						}
						position++
						goto l610
					l615:
						position, tokenIndex = position610, tokenIndex610
						if buffer[position] != rune('-') {
							goto l609
						}
						position++
					}
				l610:
					goto l536
				l609:
					position, tokenIndex = position609, tokenIndex609
				}
				add(ruleRegisterOrConstant, position537)
			}
			return true
		l536:
			position, tokenIndex = position536, tokenIndex536
			return false
		},
		/* 40 ARMConstantTweak <- <(((('u' / 's') (('x' / 'X') ('t' / 'T')) ('x' / 'w' / 'h' / 'b')) / (('l' / 'L') ('s' / 'S') ('l' / 'L')) / (('l' / 'L') ('s' / 'S') ('r' / 'R')) / (('r' / 'R') ('o' / 'O') ('r' / 'R')) / (('a' / 'A') ('s' / 'S') ('r' / 'R'))) (WS '#'? Offset)?)> */
		func() bool {
			position616, tokenIndex616 := position, tokenIndex
			{
				position617 := position
				{
					position618, tokenIndex618 := position, tokenIndex
					{
						position620, tokenIndex620 := position, tokenIndex
						if buffer[position] != rune('u') {
							goto l621
						}
						position++
						goto l620
					l621:
						position, tokenIndex = position620, tokenIndex620
						if buffer[position] != rune('s') {
							goto l619
						}
						position++
					}
				l620:
					{
						position622, tokenIndex622 := position, tokenIndex
						if buffer[position] != rune('x') {
							goto l623
						}
						position++
						goto l622
					l623:
						position, tokenIndex = position622, tokenIndex622
						if buffer[position] != rune('X') {
							goto l619
						}
						position++
					}
				l622:
					{
						position624, tokenIndex624 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l625
						}
						position++
						goto l624
					l625:
						position, tokenIndex = position624, tokenIndex624
						if buffer[position] != rune('T') {
							goto l619
						}
						position++
					}
				l624:
					{
						position626, tokenIndex626 := position, tokenIndex
						if buffer[position] != rune('x') {
							goto l627
						}
						position++
						goto l626
					l627:
						position, tokenIndex = position626, tokenIndex626
						if buffer[position] != rune('w') {
							goto l628
						}
						position++
						goto l626
					l628:
						position, tokenIndex = position626, tokenIndex626
						if buffer[position] != rune('h') {
							goto l629
						}
						position++
						goto l626
					l629:
						position, tokenIndex = position626, tokenIndex626
						if buffer[position] != rune('b') {
							goto l619
						}
						position++
					}
				l626:
					goto l618
				l619:
					position, tokenIndex = position618, tokenIndex618
					{
						position631, tokenIndex631 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l632
						}
						position++
						goto l631
					l632:
						position, tokenIndex = position631, tokenIndex631
						if buffer[position] != rune('L') {
							goto l630
						}
						position++
					}
				l631:
					{
						position633, tokenIndex633 := position, tokenIndex
						if buffer[position] != rune('s') {
							goto l634
						}
						position++
						goto l633
					l634:
						position, tokenIndex = position633, tokenIndex633
						if buffer[position] != rune('S') {
							goto l630
						}
						position++
					}
				l633:
					{
						position635, tokenIndex635 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l636
						}
						position++
						goto l635
					l636:
						position, tokenIndex = position635, tokenIndex635
						if buffer[position] != rune('L') {
							goto l630
						}
						position++
					}
				l635:
					goto l618
				l630:
					position, tokenIndex = position618, tokenIndex618
					{
						position638, tokenIndex638 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l639
						}
						position++
						goto l638
					l639:
						position, tokenIndex = position638, tokenIndex638
						if buffer[position] != rune('L') {
							goto l637
						}
						position++
					}
				l638:
					{
						position640, tokenIndex640 := position, tokenIndex
						if buffer[position] != rune('s') {
							goto l641
						}
						position++
						goto l640
					l641:
						position, tokenIndex = position640, tokenIndex640
						if buffer[position] != rune('S') {
							goto l637
						}
						position++
					}
				l640:
					{
						position642, tokenIndex642 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l643
						}
						position++
						goto l642
					l643:
						position, tokenIndex = position642, tokenIndex642
						if buffer[position] != rune('R') {
							goto l637
						}
						position++
					}
				l642:
					goto l618
				l637:
					position, tokenIndex = position618, tokenIndex618
					{
						position645, tokenIndex645 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l646
						}
						position++
						goto l645
					l646:
						position, tokenIndex = position645, tokenIndex645
						if buffer[position] != rune('R') {
							goto l644
						}
						position++
					}
				l645:
					{
						position647, tokenIndex647 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l648
						}
						position++
						goto l647
					l648:
						position, tokenIndex = position647, tokenIndex647
						if buffer[position] != rune('O') {
							goto l644
						}
						position++
					}
				l647:
					{
						position649, tokenIndex649 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l650
						}
						position++
						goto l649
					l650:
						position, tokenIndex = position649, tokenIndex649
						if buffer[position] != rune('R') {
							goto l644
						}
						position++
					}
				l649:
					goto l618
				l644:
					position, tokenIndex = position618, tokenIndex618
					{
						position651, tokenIndex651 := position, tokenIndex
						if buffer[position] != rune('a') {
							goto l652
						}
						position++
						goto l651
					l652:
						position, tokenIndex = position651, tokenIndex651
						if buffer[position] != rune('A') {
							goto l616
						}
						position++
					}
				l651:
					{
						position653, tokenIndex653 := position, tokenIndex
						if buffer[position] != rune('s') {
							goto l654
						}
						position++
						goto l653
					l654:
						position, tokenIndex = position653, tokenIndex653
						if buffer[position] != rune('S') {
							goto l616
						}
						position++
					}
				l653:
					{
						position655, tokenIndex655 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l656
						}
						position++
						goto l655
					l656:
						position, tokenIndex = position655, tokenIndex655
						if buffer[position] != rune('R') {
							goto l616
						}
						position++
					}
				l655:
				}
			l618:
				{
					position657, tokenIndex657 := position, tokenIndex
					if !_rules[ruleWS]() {
						goto l657
					}
					{
						position659, tokenIndex659 := position, tokenIndex
						if buffer[position] != rune('#') {
							goto l659
						}
						position++
						goto l660
					l659:
						position, tokenIndex = position659, tokenIndex659
					}
				l660:
					if !_rules[ruleOffset]() {
						goto l657
					}
					goto l658
				l657:
					position, tokenIndex = position657, tokenIndex657
				}
			l658:
				add(ruleARMConstantTweak, position617)
			}
			return true
		l616:
			position, tokenIndex = position616, tokenIndex616
			return false
		},
		/* 41 ARMRegister <- <((('s' / 'S') ('p' / 'P')) / (('x' / 'w' / 'd' / 'q' / 's' / 'h' / 'b') [0-9] [0-9]?) / (('x' / 'X') ('z' / 'Z') ('r' / 'R')) / (('w' / 'W') ('z' / 'Z') ('r' / 'R')) / (('n' / 'N') ('z' / 'Z') ('c' / 'C') ('v' / 'V')) / ARMVectorRegister / ('{' WS? ARMVectorRegister WS? ((',' / '-') WS? ARMVectorRegister)* WS? '}' ('[' [0-9] [0-9]? ']')?))> */
		func() bool {
			position661, tokenIndex661 := position, tokenIndex
			{
				position662 := position
				{
					position663, tokenIndex663 := position, tokenIndex
					{
						position665, tokenIndex665 := position, tokenIndex
						if buffer[position] != rune('s') {
							goto l666
						}
						position++
						goto l665
					l666:
						position, tokenIndex = position665, tokenIndex665
						if buffer[position] != rune('S') {
							goto l664
						}
						position++
					}
				l665:
					{
						position667, tokenIndex667 := position, tokenIndex
						if buffer[position] != rune('p') {
							goto l668
						}
						position++
						goto l667
					l668:
						position, tokenIndex = position667, tokenIndex667
						if buffer[position] != rune('P') {
							goto l664
						}
						position++
					}
				l667:
					goto l663
				l664:
					position, tokenIndex = position663, tokenIndex663
					{
						position670, tokenIndex670 := position, tokenIndex
						if buffer[position] != rune('x') {
							goto l671
						}
						position++
						goto l670
					l671:
						position, tokenIndex = position670, tokenIndex670
						if buffer[position] != rune('w') {
							goto l672
						}
						position++
						goto l670
					l672:
						position, tokenIndex = position670, tokenIndex670
						if buffer[position] != rune('d') {
							goto l673
						}
						position++
						goto l670
					l673:
						position, tokenIndex = position670, tokenIndex670
						if buffer[position] != rune('q') {
							goto l674
						}
						position++
						goto l670
					l674:
						position, tokenIndex = position670, tokenIndex670
						if buffer[position] != rune('s') {
							goto l675
						}
						position++
						goto l670
					l675:
						position, tokenIndex = position670, tokenIndex670
						if buffer[position] != rune('h') {
							goto l676
						}
						position++
						goto l670
					l676:
						position, tokenIndex = position670, tokenIndex670
						if buffer[position] != rune('b') {
							goto l669
						}
						position++
					}
				l670:
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l669
					}
					position++
					{
						position677, tokenIndex677 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l677
						}
						position++
						goto l678
					l677:
						position, tokenIndex = position677, tokenIndex677
					}
				l678:
					goto l663
				l669:
					position, tokenIndex = position663, tokenIndex663
					{
						position680, tokenIndex680 := position, tokenIndex
						if buffer[position] != rune('x') {
							goto l681
						}
						position++
						goto l680
					l681:
						position, tokenIndex = position680, tokenIndex680
						if buffer[position] != rune('X') {
							goto l679
						}
						position++
					}
				l680:
					{
						position682, tokenIndex682 := position, tokenIndex
						if buffer[position] != rune('z') {
							goto l683
						}
						position++
						goto l682
					l683:
						position, tokenIndex = position682, tokenIndex682
						if buffer[position] != rune('Z') {
							goto l679
						}
						position++
					}
				l682:
					{
						position684, tokenIndex684 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l685
						}
						position++
						goto l684
					l685:
						position, tokenIndex = position684, tokenIndex684
						if buffer[position] != rune('R') {
							goto l679
						}
						position++
					}
				l684:
					goto l663
				l679:
					position, tokenIndex = position663, tokenIndex663
					{
						position687, tokenIndex687 := position, tokenIndex
						if buffer[position] != rune('w') {
							goto l688
						}
						position++
						goto l687
					l688:
						position, tokenIndex = position687, tokenIndex687
						if buffer[position] != rune('W') {
							goto l686
						}
						position++
					}
				l687:
					{
						position689, tokenIndex689 := position, tokenIndex
						if buffer[position] != rune('z') {
							goto l690
						}
						position++
						goto l689
					l690:
						position, tokenIndex = position689, tokenIndex689
						if buffer[position] != rune('Z') {
							goto l686
						}
						position++
					}
				l689:
					{
						position691, tokenIndex691 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l692
						}
						position++
						goto l691
					l692:
						position, tokenIndex = position691, tokenIndex691
						if buffer[position] != rune('R') {
							goto l686
						}
						position++
					}
				l691:
					goto l663
				l686:
					position, tokenIndex = position663, tokenIndex663
					{
						position694, tokenIndex694 := position, tokenIndex
						if buffer[position] != rune('n') {
							goto l695
						}
						position++
						goto l694
					l695:
						position, tokenIndex = position694, tokenIndex694
						if buffer[position] != rune('N') {
							goto l693
						}
						position++
					}
				l694:
					{
						position696, tokenIndex696 := position, tokenIndex
						if buffer[position] != rune('z') {
							goto l697
						}
						position++
						goto l696
					l697:
						position, tokenIndex = position696, tokenIndex696
						if buffer[position] != rune('Z') {
							goto l693
						}
						position++
					}
				l696:
					{
						position698, tokenIndex698 := position, tokenIndex
						if buffer[position] != rune('c') {
							goto l699
						}
						position++
						goto l698
					l699:
						position, tokenIndex = position698, tokenIndex698
						if buffer[position] != rune('C') {
							goto l693
						}
						position++
					}
				l698:
					{
						position700, tokenIndex700 := position, tokenIndex
						if buffer[position] != rune('v') {
							goto l701
						}
						position++
						goto l700
					l701:
						position, tokenIndex = position700, tokenIndex700
						if buffer[position] != rune('V') {
							goto l693
						}
						position++
					}
				l700:
					goto l663
				l693:
					position, tokenIndex = position663, tokenIndex663
					if !_rules[ruleARMVectorRegister]() {
						goto l702
					}
					goto l663
				l702:
					position, tokenIndex = position663, tokenIndex663
					if buffer[position] != rune('{') {
						goto l661
					}
					position++
					{
						position703, tokenIndex703 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l703
						}
						goto l704
					l703:
						position, tokenIndex = position703, tokenIndex703
					}
				l704:
					if !_rules[ruleARMVectorRegister]() {
						goto l661
					}
					{
						position705, tokenIndex705 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l705
						}
						goto l706
					l705:
						position, tokenIndex = position705, tokenIndex705
					}
				l706:
				l707:
					{
						position708, tokenIndex708 := position, tokenIndex
						{
							position709, tokenIndex709 := position, tokenIndex
							if buffer[position] != rune(',') {
								goto l710
							}
							position++
							goto l709
						l710:
							position, tokenIndex = position709, tokenIndex709
							if buffer[position] != rune('-') {
								goto l708
							}
							position++
						}
					l709:
						{
							position711, tokenIndex711 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l711
							}
							goto l712
						l711:
							position, tokenIndex = position711, tokenIndex711
						}
					l712:
						if !_rules[ruleARMVectorRegister]() {
							goto l708
						}
						goto l707
					l708:
						position, tokenIndex = position708, tokenIndex708
					}
					{
						position713, tokenIndex713 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l713
						}
						goto l714
					l713:
						position, tokenIndex = position713, tokenIndex713
					}
				l714:
					if buffer[position] != rune('}') {
						goto l661
					}
					position++
					{
						position715, tokenIndex715 := position, tokenIndex
						if buffer[position] != rune('[') {
							goto l715
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l715
						}
						position++
						{
							position717, tokenIndex717 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l717
							}
							position++
							goto l718
						l717:
							position, tokenIndex = position717, tokenIndex717
						}
					l718:
						if buffer[position] != rune(']') {
							goto l715
						}
						position++
						goto l716
					l715:
						position, tokenIndex = position715, tokenIndex715
					}
				l716:
				}
			l663:
				add(ruleARMRegister, position662)
			}
			return true
		l661:
			position, tokenIndex = position661, tokenIndex661
			return false
		},
		/* 42 ARMVectorRegister <- <(('v' / 'V') [0-9] [0-9]? ('.' [0-9]* ('b' / 's' / 'd' / 'h' / 'q') ('[' [0-9] [0-9]? ']')?)?)> */
		func() bool {
			position719, tokenIndex719 := position, tokenIndex
			{
				position720 := position
				{
					position721, tokenIndex721 := position, tokenIndex
					if buffer[position] != rune('v') {
						goto l722
					}
					position++
					goto l721
				l722:
					position, tokenIndex = position721, tokenIndex721
					if buffer[position] != rune('V') {
						goto l719
					}
					position++
				}
			l721:
				if c := buffer[position]; c < rune('0') || c > rune('9') {
					goto l719
				}
				position++
				{
					position723, tokenIndex723 := position, tokenIndex
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l723
					}
					position++
					goto l724
				l723:
					position, tokenIndex = position723, tokenIndex723
				}
			l724:
				{
					position725, tokenIndex725 := position, tokenIndex
					if buffer[position] != rune('.') {
						goto l725
					}
					position++
				l727:
					{
						position728, tokenIndex728 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l728
						}
						position++
						goto l727
					l728:
						position, tokenIndex = position728, tokenIndex728
					}
					{
						position729, tokenIndex729 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l730
						}
						position++
						goto l729
					l730:
						position, tokenIndex = position729, tokenIndex729
						if buffer[position] != rune('s') {
							goto l731
						}
						position++
						goto l729
					l731:
						position, tokenIndex = position729, tokenIndex729
						if buffer[position] != rune('d') {
							goto l732
						}
						position++
						goto l729
					l732:
						position, tokenIndex = position729, tokenIndex729
						if buffer[position] != rune('h') {
							goto l733
						}
						position++
						goto l729
					l733:
						position, tokenIndex = position729, tokenIndex729
						if buffer[position] != rune('q') {
							goto l725
						}
						position++
					}
				l729:
					{
						position734, tokenIndex734 := position, tokenIndex
						if buffer[position] != rune('[') {
							goto l734
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l734
						}
						position++
						{
							position736, tokenIndex736 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l736
							}
							position++
							goto l737
						l736:
							position, tokenIndex = position736, tokenIndex736
						}
					l737:
						if buffer[position] != rune(']') {
							goto l734
						}
						position++
						goto l735
					l734:
						position, tokenIndex = position734, tokenIndex734
					}
				l735:
					goto l726
				l725:
					position, tokenIndex = position725, tokenIndex725
				}
			l726:
				add(ruleARMVectorRegister, position720)
			}
			return true
		l719:
			position, tokenIndex = position719, tokenIndex719
			return false
		},
		/* 43 MemoryRef <- <((SymbolRef BaseIndexScale) / SymbolRef / Low12BitsSymbolRef / (Offset* BaseIndexScale) / (SegmentRegister Offset BaseIndexScale) / (SegmentRegister BaseIndexScale) / (SegmentRegister Offset) / ARMBaseIndexScale / BaseIndexScale)> */
		func() bool {
			position738, tokenIndex738 := position, tokenIndex
			{
				position739 := position
				{
					position740, tokenIndex740 := position, tokenIndex
					if !_rules[ruleSymbolRef]() {
						goto l741
					}
					if !_rules[ruleBaseIndexScale]() {
						goto l741
					}
					goto l740
				l741:
					position, tokenIndex = position740, tokenIndex740
					if !_rules[ruleSymbolRef]() {
						goto l742
					}
					goto l740
				l742:
					position, tokenIndex = position740, tokenIndex740
					if !_rules[ruleLow12BitsSymbolRef]() {
						goto l743
					}
					goto l740
				l743:
					position, tokenIndex = position740, tokenIndex740
				l745:
					{
						position746, tokenIndex746 := position, tokenIndex
						if !_rules[ruleOffset]() {
							goto l746
						}
						goto l745
					l746:
						position, tokenIndex = position746, tokenIndex746
					}
					if !_rules[ruleBaseIndexScale]() {
						goto l744
					}
					goto l740
				l744:
					position, tokenIndex = position740, tokenIndex740
					if !_rules[ruleSegmentRegister]() {
						goto l747
					}
					if !_rules[ruleOffset]() {
						goto l747
					}
					if !_rules[ruleBaseIndexScale]() {
						goto l747
					}
					goto l740
				l747:
					position, tokenIndex = position740, tokenIndex740
					if !_rules[ruleSegmentRegister]() {
						goto l748
					}
					if !_rules[ruleBaseIndexScale]() {
						goto l748
					}
					goto l740
				l748:
					position, tokenIndex = position740, tokenIndex740
					if !_rules[ruleSegmentRegister]() {
						goto l749
					}
					if !_rules[ruleOffset]() {
						goto l749
					}
					goto l740
				l749:
					position, tokenIndex = position740, tokenIndex740
					if !_rules[ruleARMBaseIndexScale]() {
						goto l750
					}
					goto l740
				l750:
					position, tokenIndex = position740, tokenIndex740
					if !_rules[ruleBaseIndexScale]() {
						goto l738
					}
				}
			l740:
				add(ruleMemoryRef, position739)
			}
			return true
		l738:
			position, tokenIndex = position738, tokenIndex738
			return false
		},
		/* 44 SymbolRef <- <((Offset* '+')? (LocalSymbol / SymbolName) Offset* ('@' Section Offset*)?)> */
		func() bool {
			position751, tokenIndex751 := position, tokenIndex
			{
				position752 := position
				{
					position753, tokenIndex753 := position, tokenIndex
				l755:
					{
						position756, tokenIndex756 := position, tokenIndex
						if !_rules[ruleOffset]() {
							goto l756
						}
						goto l755
					l756:
						position, tokenIndex = position756, tokenIndex756
					}
					if buffer[position] != rune('+') {
						goto l753
					}
					position++
					goto l754
				l753:
					position, tokenIndex = position753, tokenIndex753
				}
			l754:
				{
					position757, tokenIndex757 := position, tokenIndex
					if !_rules[ruleLocalSymbol]() {
						goto l758
					}
					goto l757
				l758:
					position, tokenIndex = position757, tokenIndex757
					if !_rules[ruleSymbolName]() {
						goto l751
					}
				}
			l757:
			l759:
				{
					position760, tokenIndex760 := position, tokenIndex
					if !_rules[ruleOffset]() {
						goto l760
					}
					goto l759
				l760:
					position, tokenIndex = position760, tokenIndex760
				}
				{
					position761, tokenIndex761 := position, tokenIndex
					if buffer[position] != rune('@') {
						goto l761
					}
					position++
					if !_rules[ruleSection]() {
						goto l761
					}
				l763:
					{
						position764, tokenIndex764 := position, tokenIndex
						if !_rules[ruleOffset]() {
							goto l764
						}
						goto l763
					l764:
						position, tokenIndex = position764, tokenIndex764
					}
					goto l762
				l761:
					position, tokenIndex = position761, tokenIndex761
				}
			l762:
				add(ruleSymbolRef, position752)
			}
			return true
		l751:
			position, tokenIndex = position751, tokenIndex751
			return false
		},
		/* 45 Low12BitsSymbolRef <- <(':' ('l' / 'L') ('o' / 'O') '1' '2' ':' (LocalSymbol / SymbolName) Offset?)> */
		func() bool {
			position765, tokenIndex765 := position, tokenIndex
			{
				position766 := position
				if buffer[position] != rune(':') {
					goto l765
				}
				position++
				{
					position767, tokenIndex767 := position, tokenIndex
					if buffer[position] != rune('l') {
						goto l768
					}
					position++
					goto l767
				l768:
					position, tokenIndex = position767, tokenIndex767
					if buffer[position] != rune('L') {
						goto l765
					}
					position++
				}
			l767:
				{
					position769, tokenIndex769 := position, tokenIndex
					if buffer[position] != rune('o') {
						goto l770
					}
					position++
					goto l769
				l770:
					position, tokenIndex = position769, tokenIndex769
					if buffer[position] != rune('O') {
						goto l765
					}
					position++
				}
			l769:
				if buffer[position] != rune('1') {
					goto l765
				}
				position++
				if buffer[position] != rune('2') {
					goto l765
				}
				position++
				if buffer[position] != rune(':') {
					goto l765
				}
				position++
				{
					position771, tokenIndex771 := position, tokenIndex
					if !_rules[ruleLocalSymbol]() {
						goto l772
					}
					goto l771
				l772:
					position, tokenIndex = position771, tokenIndex771
					if !_rules[ruleSymbolName]() {
						goto l765
					}
				}
			l771:
				{
					position773, tokenIndex773 := position, tokenIndex
					if !_rules[ruleOffset]() {
						goto l773
					}
					goto l774
				l773:
					position, tokenIndex = position773, tokenIndex773
				}
			l774:
				add(ruleLow12BitsSymbolRef, position766)
			}
			return true
		l765:
			position, tokenIndex = position765, tokenIndex765
			return false
		},
		/* 46 ARMBaseIndexScale <- <('[' ARMRegister (',' WS? (('#'? Offset (('*' [0-9]+) / ('*' '(' [0-9]+ Operator [0-9]+ ')') / ('+' [0-9]+)*)?) / ('#'? ARMGOTLow12) / ('#'? Low12BitsSymbolRef) / ARMRegister) (',' WS? ARMConstantTweak)?)? ']' ARMPostincrement?)> */
		func() bool {
			position775, tokenIndex775 := position, tokenIndex
			{
				position776 := position
				if buffer[position] != rune('[') {
					goto l775
				}
				position++
				if !_rules[ruleARMRegister]() {
					goto l775
				}
				{
					position777, tokenIndex777 := position, tokenIndex
					if buffer[position] != rune(',') {
						goto l777
					}
					position++
					{
						position779, tokenIndex779 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l779
						}
						goto l780
					l779:
						position, tokenIndex = position779, tokenIndex779
					}
				l780:
					{
						position781, tokenIndex781 := position, tokenIndex
						{
							position783, tokenIndex783 := position, tokenIndex
							if buffer[position] != rune('#') {
								goto l783
							}
							position++
							goto l784
						l783:
							position, tokenIndex = position783, tokenIndex783
						}
					l784:
						if !_rules[ruleOffset]() {
							goto l782
						}
						{
							position785, tokenIndex785 := position, tokenIndex
							{
								position787, tokenIndex787 := position, tokenIndex
								if buffer[position] != rune('*') {
									goto l788
								}
								position++
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l788
								}
								position++
							l789:
								{
									position790, tokenIndex790 := position, tokenIndex
									if c := buffer[position]; c < rune('0') || c > rune('9') {
										goto l790
									}
									position++
									goto l789
								l790:
									position, tokenIndex = position790, tokenIndex790
								}
								goto l787
							l788:
								position, tokenIndex = position787, tokenIndex787
								if buffer[position] != rune('*') {
									goto l791
								}
								position++
								if buffer[position] != rune('(') {
									goto l791
								}
								position++
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l791
								}
								position++
							l792:
								{
									position793, tokenIndex793 := position, tokenIndex
									if c := buffer[position]; c < rune('0') || c > rune('9') {
										goto l793
									}
									position++
									goto l792
								l793:
									position, tokenIndex = position793, tokenIndex793
								}
								if !_rules[ruleOperator]() {
									goto l791
								}
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l791
								}
								position++
							l794:
								{
									position795, tokenIndex795 := position, tokenIndex
									if c := buffer[position]; c < rune('0') || c > rune('9') {
										goto l795
									}
									position++
									goto l794
								l795:
									position, tokenIndex = position795, tokenIndex795
								}
								if buffer[position] != rune(')') {
									goto l791
								}
								position++
								goto l787
							l791:
								position, tokenIndex = position787, tokenIndex787
							l796:
								{
									position797, tokenIndex797 := position, tokenIndex
									if buffer[position] != rune('+') {
										goto l797
									}
									position++
									if c := buffer[position]; c < rune('0') || c > rune('9') {
										goto l797
									}
									position++
								l798:
									{
										position799, tokenIndex799 := position, tokenIndex
										if c := buffer[position]; c < rune('0') || c > rune('9') {
											goto l799
										}
										position++
										goto l798
									l799:
										position, tokenIndex = position799, tokenIndex799
									}
									goto l796
								l797:
									position, tokenIndex = position797, tokenIndex797
								}
							}
						l787:
							goto l786

							position, tokenIndex = position785, tokenIndex785
						}
					l786:
						goto l781
					l782:
						position, tokenIndex = position781, tokenIndex781
						{
							position801, tokenIndex801 := position, tokenIndex
							if buffer[position] != rune('#') {
								goto l801
							}
							position++
							goto l802
						l801:
							position, tokenIndex = position801, tokenIndex801
						}
					l802:
						if !_rules[ruleARMGOTLow12]() {
							goto l800
						}
						goto l781
					l800:
						position, tokenIndex = position781, tokenIndex781
						{
							position804, tokenIndex804 := position, tokenIndex
							if buffer[position] != rune('#') {
								goto l804
							}
							position++
							goto l805
						l804:
							position, tokenIndex = position804, tokenIndex804
						}
					l805:
						if !_rules[ruleLow12BitsSymbolRef]() {
							goto l803
						}
						goto l781
					l803:
						position, tokenIndex = position781, tokenIndex781
						if !_rules[ruleARMRegister]() {
							goto l777
						}
					}
				l781:
					{
						position806, tokenIndex806 := position, tokenIndex
						if buffer[position] != rune(',') {
							goto l806
						}
						position++
						{
							position808, tokenIndex808 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l808
							}
							goto l809
						l808:
							position, tokenIndex = position808, tokenIndex808
						}
					l809:
						if !_rules[ruleARMConstantTweak]() {
							goto l806
						}
						goto l807
					l806:
						position, tokenIndex = position806, tokenIndex806
					}
				l807:
					goto l778
				l777:
					position, tokenIndex = position777, tokenIndex777
				}
			l778:
				if buffer[position] != rune(']') {
					goto l775
				}
				position++
				{
					position810, tokenIndex810 := position, tokenIndex
					if !_rules[ruleARMPostincrement]() {
						goto l810
					}
					goto l811
				l810:
					position, tokenIndex = position810, tokenIndex810
				}
			l811:
				add(ruleARMBaseIndexScale, position776)
			}
			return true
		l775:
			position, tokenIndex = position775, tokenIndex775
			return false
		},
		/* 47 ARMGOTLow12 <- <(':' ('g' / 'G') ('o' / 'O') ('t' / 'T') '_' ('l' / 'L') ('o' / 'O') '1' '2' ':' SymbolName)> */
		func() bool {
			position812, tokenIndex812 := position, tokenIndex
			{
				position813 := position
				if buffer[position] != rune(':') {
					goto l812
				}
				position++
				{
					position814, tokenIndex814 := position, tokenIndex
					if buffer[position] != rune('g') {
						goto l815
					}
					position++
					goto l814
				l815:
					position, tokenIndex = position814, tokenIndex814
					if buffer[position] != rune('G') {
						goto l812
					}
					position++
				}
			l814:
				{
					position816, tokenIndex816 := position, tokenIndex
					if buffer[position] != rune('o') {
						goto l817
					}
					position++
					goto l816
				l817:
					position, tokenIndex = position816, tokenIndex816
					if buffer[position] != rune('O') {
						goto l812
					}
					position++
				}
			l816:
				{
					position818, tokenIndex818 := position, tokenIndex
					if buffer[position] != rune('t') {
						goto l819
					}
					position++
					goto l818
				l819:
					position, tokenIndex = position818, tokenIndex818
					if buffer[position] != rune('T') {
						goto l812
					}
					position++
				}
			l818:
				if buffer[position] != rune('_') {
					goto l812
				}
				position++
				{
					position820, tokenIndex820 := position, tokenIndex
					if buffer[position] != rune('l') {
						goto l821
					}
					position++
					goto l820
				l821:
					position, tokenIndex = position820, tokenIndex820
					if buffer[position] != rune('L') {
						goto l812
					}
					position++
				}
			l820:
				{
					position822, tokenIndex822 := position, tokenIndex
					if buffer[position] != rune('o') {
						goto l823
					}
					position++
					goto l822
				l823:
					position, tokenIndex = position822, tokenIndex822
					if buffer[position] != rune('O') {
						goto l812
					}
					position++
				}
			l822:
				if buffer[position] != rune('1') {
					goto l812
				}
				position++
				if buffer[position] != rune('2') {
					goto l812
				}
				position++
				if buffer[position] != rune(':') {
					goto l812
				}
				position++
				if !_rules[ruleSymbolName]() {
					goto l812
				}
				add(ruleARMGOTLow12, position813)
			}
			return true
		l812:
			position, tokenIndex = position812, tokenIndex812
			return false
		},
		/* 48 ARMPostincrement <- <'!'> */
		func() bool {
			position824, tokenIndex824 := position, tokenIndex
			{
				position825 := position
				if buffer[position] != rune('!') {
					goto l824
				}
				position++
				add(ruleARMPostincrement, position825)
			}
			return true
		l824:
			position, tokenIndex = position824, tokenIndex824
			return false
		},
		/* 49 BaseIndexScale <- <('(' RegisterOrConstant? WS? (',' WS? RegisterOrConstant WS? (',' [0-9]+)?)? ')')> */
		func() bool {
			position826, tokenIndex826 := position, tokenIndex
			{
				position827 := position
				if buffer[position] != rune('(') {
					goto l826
				}
				position++
				{
					position828, tokenIndex828 := position, tokenIndex
					if !_rules[ruleRegisterOrConstant]() {
						goto l828
					}
					goto l829
				l828:
					position, tokenIndex = position828, tokenIndex828
				}
			l829:
				{
					position830, tokenIndex830 := position, tokenIndex
					if !_rules[ruleWS]() {
						goto l830
					}
					goto l831
				l830:
					position, tokenIndex = position830, tokenIndex830
				}
			l831:
				{
					position832, tokenIndex832 := position, tokenIndex
					if buffer[position] != rune(',') {
						goto l832
					}
					position++
					{
						position834, tokenIndex834 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l834
						}
						goto l835
					l834:
						position, tokenIndex = position834, tokenIndex834
					}
				l835:
					if !_rules[ruleRegisterOrConstant]() {
						goto l832
					}
					{
						position836, tokenIndex836 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l836
						}
						goto l837
					l836:
						position, tokenIndex = position836, tokenIndex836
					}
				l837:
					{
						position838, tokenIndex838 := position, tokenIndex
						if buffer[position] != rune(',') {
							goto l838
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l838
						}
						position++
					l840:
						{
							position841, tokenIndex841 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l841
							}
							position++
							goto l840
						l841:
							position, tokenIndex = position841, tokenIndex841
						}
						goto l839
					l838:
						position, tokenIndex = position838, tokenIndex838
					}
				l839:
					goto l833
				l832:
					position, tokenIndex = position832, tokenIndex832
				}
			l833:
				if buffer[position] != rune(')') {
					goto l826
				}
				position++
				add(ruleBaseIndexScale, position827)
			}
			return true
		l826:
			position, tokenIndex = position826, tokenIndex826
			return false
		},
		/* 50 Operator <- <('+' / '-')> */
		func() bool {
			position842, tokenIndex842 := position, tokenIndex
			{
				position843 := position
				{
					position844, tokenIndex844 := position, tokenIndex
					if buffer[position] != rune('+') {
						goto l845
					}
					position++
					goto l844
				l845:
					position, tokenIndex = position844, tokenIndex844
					if buffer[position] != rune('-') {
						goto l842
					}
					position++
				}
			l844:
				add(ruleOperator, position843)
			}
			return true
		l842:
			position, tokenIndex = position842, tokenIndex842
			return false
		},
		/* 51 OffsetOperator <- <('+' / '-' / '*')> */
		func() bool {
			position846, tokenIndex846 := position, tokenIndex
			{
				position847 := position
				{
					position848, tokenIndex848 := position, tokenIndex
					if buffer[position] != rune('+') {
						goto l849
					}
					position++
					goto l848
				l849:
					position, tokenIndex = position848, tokenIndex848
					if buffer[position] != rune('-') {
						goto l850
					}
					position++
					goto l848
				l850:
					position, tokenIndex = position848, tokenIndex848
					if buffer[position] != rune('*') {
						goto l846
					}
					position++
				}
			l848:
				add(ruleOffsetOperator, position847)
			}
			return true
		l846:
			position, tokenIndex = position846, tokenIndex846
			return false
		},
		/* 52 Offset <- <('+'? '-'? (('0' ('b' / 'B') ('0' / '1')+) / ('0' ('x' / 'X') ([0-9] / [0-9] / ([a-f] / [A-F]))+) / ((([0-9]+ WS OffsetOperator [0-9]+) / ([0-9]+ (OffsetOperator '(' [0-9]+ OffsetOperator [0-9]+ ')')?) / ([0-9]+ (OffsetOperator [0-9]+ OffsetOperator [0-9]+)?) / ([0-9]+ (OffsetOperator [0-9]+)?) / ('(' [0-9]+ WS? OffsetOperator WS? [0-9]+ ')' OffsetOperator [0-9]+ OffsetOperator [0-9]+) / ('(' [0-9]+ WS? OffsetOperator WS? [0-9]+ ')' OffsetOperator [0-9]+ !'x') / ('(' [0-9]+ WS? OffsetOperator WS? [0-9]+ ')') / ('(' [0-9]+ WS? OffsetOperator WS? [0-9]+ WS? OffsetOperator WS? [0-9]+ ')')) !([a-z] / [A-Z]))))> */
		func() bool {
			position851, tokenIndex851 := position, tokenIndex
			{
				position852 := position
				{
					position853, tokenIndex853 := position, tokenIndex
					if buffer[position] != rune('+') {
						goto l853
					}
					position++
					goto l854
				l853:
					position, tokenIndex = position853, tokenIndex853
				}
			l854:
				{
					position855, tokenIndex855 := position, tokenIndex
					if buffer[position] != rune('-') {
						goto l855
					}
					position++
					goto l856
				l855:
					position, tokenIndex = position855, tokenIndex855
				}
			l856:
				{
					position857, tokenIndex857 := position, tokenIndex
					if buffer[position] != rune('0') {
						goto l858
					}
					position++
					{
						position859, tokenIndex859 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l860
						}
						position++
						goto l859
					l860:
						position, tokenIndex = position859, tokenIndex859
						if buffer[position] != rune('B') {
							goto l858
						}
						position++
					}
				l859:
					{
						position863, tokenIndex863 := position, tokenIndex
						if buffer[position] != rune('0') {
							goto l864
						}
						position++
						goto l863
					l864:
						position, tokenIndex = position863, tokenIndex863
						if buffer[position] != rune('1') {
							goto l858
						}
						position++
					}
				l863:
				l861:
					{
						position862, tokenIndex862 := position, tokenIndex
						{
							position865, tokenIndex865 := position, tokenIndex
							if buffer[position] != rune('0') {
								goto l866
							}
							position++
							goto l865
						l866:
							position, tokenIndex = position865, tokenIndex865
							if buffer[position] != rune('1') {
								goto l862
							}
							position++
						}
					l865:
						goto l861
					l862:
						position, tokenIndex = position862, tokenIndex862
					}
					goto l857
				l858:
					position, tokenIndex = position857, tokenIndex857
					if buffer[position] != rune('0') {
						goto l867
					}
					position++
					{
						position868, tokenIndex868 := position, tokenIndex
						if buffer[position] != rune('x') {
							goto l869
						}
						position++
						goto l868
					l869:
						position, tokenIndex = position868, tokenIndex868
						if buffer[position] != rune('X') {
							goto l867
						}
						position++
					}
				l868:
					{
						position872, tokenIndex872 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l873
						}
						position++
						goto l872
					l873:
						position, tokenIndex = position872, tokenIndex872
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l874
						}
						position++
						goto l872
					l874:
						position, tokenIndex = position872, tokenIndex872
						{
							position875, tokenIndex875 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('f') {
								goto l876
							}
							position++
							goto l875
						l876:
							position, tokenIndex = position875, tokenIndex875
							if c := buffer[position]; c < rune('A') || c > rune('F') {
								goto l867
							}
							position++
						}
					l875:
					}
				l872:
				l870:
					{
						position871, tokenIndex871 := position, tokenIndex
						{
							position877, tokenIndex877 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l878
							}
							position++
							goto l877
						l878:
							position, tokenIndex = position877, tokenIndex877
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l879
							}
							position++
							goto l877
						l879:
							position, tokenIndex = position877, tokenIndex877
							{
								position880, tokenIndex880 := position, tokenIndex
								if c := buffer[position]; c < rune('a') || c > rune('f') {
									goto l881
								}
								position++
								goto l880
							l881:
								position, tokenIndex = position880, tokenIndex880
								if c := buffer[position]; c < rune('A') || c > rune('F') {
									goto l871
								}
								position++
							}
						l880:
						}
					l877:
						goto l870
					l871:
						position, tokenIndex = position871, tokenIndex871
					}
					goto l857
				l867:
					position, tokenIndex = position857, tokenIndex857
					{
						position882, tokenIndex882 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l883
						}
						position++
					l884:
						{
							position885, tokenIndex885 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l885
							}
							position++
							goto l884
						l885:
							position, tokenIndex = position885, tokenIndex885
						}
						if !_rules[ruleWS]() {
							goto l883
						}
						if !_rules[ruleOffsetOperator]() {
							goto l883
						}
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l883
						}
						position++
					l886:
						{
							position887, tokenIndex887 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l887
							}
							position++
							goto l886
						l887:
							position, tokenIndex = position887, tokenIndex887
						}
						goto l882
					l883:
						position, tokenIndex = position882, tokenIndex882
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l888
						}
						position++
					l889:
						{
							position890, tokenIndex890 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l890
							}
							position++
							goto l889
						l890:
							position, tokenIndex = position890, tokenIndex890
						}
						{
							position891, tokenIndex891 := position, tokenIndex
							if !_rules[ruleOffsetOperator]() {
								goto l891
							}
							if buffer[position] != rune('(') {
								goto l891
							}
							position++
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l891
							}
							position++
						l893:
							{
								position894, tokenIndex894 := position, tokenIndex
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l894
								}
								position++
								goto l893
							l894:
								position, tokenIndex = position894, tokenIndex894
							}
							if !_rules[ruleOffsetOperator]() {
								goto l891
							}
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l891
							}
							position++
						l895:
							{
								position896, tokenIndex896 := position, tokenIndex
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l896
								}
								position++
								goto l895
							l896:
								position, tokenIndex = position896, tokenIndex896
							}
							if buffer[position] != rune(')') {
								goto l891
							}
							position++
							goto l892
						l891:
							position, tokenIndex = position891, tokenIndex891
						}
					l892:
						goto l882
					l888:
						position, tokenIndex = position882, tokenIndex882
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l897
						}
						position++
					l898:
						{
							position899, tokenIndex899 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l899
							}
							position++
							goto l898
						l899:
							position, tokenIndex = position899, tokenIndex899
						}
						{
							position900, tokenIndex900 := position, tokenIndex
							if !_rules[ruleOffsetOperator]() {
								goto l900
							}
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l900
							}
							position++
						l902:
							{
								position903, tokenIndex903 := position, tokenIndex
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l903
								}
								position++
								goto l902
							l903:
								position, tokenIndex = position903, tokenIndex903
							}
							if !_rules[ruleOffsetOperator]() {
								goto l900
							}
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l900
							}
							position++
						l904:
							{
								position905, tokenIndex905 := position, tokenIndex
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l905
								}
								position++
								goto l904
							l905:
								position, tokenIndex = position905, tokenIndex905
							}
							goto l901
						l900:
							position, tokenIndex = position900, tokenIndex900
						}
					l901:
						goto l882
					l897:
						position, tokenIndex = position882, tokenIndex882
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l906
						}
						position++
					l907:
						{
							position908, tokenIndex908 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l908
							}
							position++
							goto l907
						l908:
							position, tokenIndex = position908, tokenIndex908
						}
						{
							position909, tokenIndex909 := position, tokenIndex
							if !_rules[ruleOffsetOperator]() {
								goto l909
							}
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l909
							}
							position++
						l911:
							{
								position912, tokenIndex912 := position, tokenIndex
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l912
								}
								position++
								goto l911
							l912:
								position, tokenIndex = position912, tokenIndex912
							}
							goto l910
						l909:
							position, tokenIndex = position909, tokenIndex909
						}
					l910:
						goto l882
					l906:
						position, tokenIndex = position882, tokenIndex882
						if buffer[position] != rune('(') {
							goto l913
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l913
						}
						position++
					l914:
						{
							position915, tokenIndex915 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l915
							}
							position++
							goto l914
						l915:
							position, tokenIndex = position915, tokenIndex915
						}
						{
							position916, tokenIndex916 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l916
							}
							goto l917
						l916:
							position, tokenIndex = position916, tokenIndex916
						}
					l917:
						if !_rules[ruleOffsetOperator]() {
							goto l913
						}
						{
							position918, tokenIndex918 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l918
							}
							goto l919
						l918:
							position, tokenIndex = position918, tokenIndex918
						}
					l919:
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l913
						}
						position++
					l920:
						{
							position921, tokenIndex921 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l921
							}
							position++
							goto l920
						l921:
							position, tokenIndex = position921, tokenIndex921
						}
						if buffer[position] != rune(')') {
							goto l913
						}
						position++
						if !_rules[ruleOffsetOperator]() {
							goto l913
						}
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l913
						}
						position++
					l922:
						{
							position923, tokenIndex923 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l923
							}
							position++
							goto l922
						l923:
							position, tokenIndex = position923, tokenIndex923
						}
						if !_rules[ruleOffsetOperator]() {
							goto l913
						}
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l913
						}
						position++
					l924:
						{
							position925, tokenIndex925 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l925
							}
							position++
							goto l924
						l925:
							position, tokenIndex = position925, tokenIndex925
						}
						goto l882
					l913:
						position, tokenIndex = position882, tokenIndex882
						if buffer[position] != rune('(') {
							goto l926
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l926
						}
						position++
					l927:
						{
							position928, tokenIndex928 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l928
							}
							position++
							goto l927
						l928:
							position, tokenIndex = position928, tokenIndex928
						}
						{
							position929, tokenIndex929 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l929
							}
							goto l930
						l929:
							position, tokenIndex = position929, tokenIndex929
						}
					l930:
						if !_rules[ruleOffsetOperator]() {
							goto l926
						}
						{
							position931, tokenIndex931 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l931
							}
							goto l932
						l931:
							position, tokenIndex = position931, tokenIndex931
						}
					l932:
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l926
						}
						position++
					l933:
						{
							position934, tokenIndex934 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l934
							}
							position++
							goto l933
						l934:
							position, tokenIndex = position934, tokenIndex934
						}
						if buffer[position] != rune(')') {
							goto l926
						}
						position++
						if !_rules[ruleOffsetOperator]() {
							goto l926
						}
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l926
						}
						position++
					l935:
						{
							position936, tokenIndex936 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l936
							}
							position++
							goto l935
						l936:
							position, tokenIndex = position936, tokenIndex936
						}
						{
							position937, tokenIndex937 := position, tokenIndex
							if buffer[position] != rune('x') {
								goto l937
							}
							position++
							goto l926
						l937:
							position, tokenIndex = position937, tokenIndex937
						}
						goto l882
					l926:
						position, tokenIndex = position882, tokenIndex882
						if buffer[position] != rune('(') {
							goto l938
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l938
						}
						position++
					l939:
						{
							position940, tokenIndex940 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l940
							}
							position++
							goto l939
						l940:
							position, tokenIndex = position940, tokenIndex940
						}
						{
							position941, tokenIndex941 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l941
							}
							goto l942
						l941:
							position, tokenIndex = position941, tokenIndex941
						}
					l942:
						if !_rules[ruleOffsetOperator]() {
							goto l938
						}
						{
							position943, tokenIndex943 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l943
							}
							goto l944
						l943:
							position, tokenIndex = position943, tokenIndex943
						}
					l944:
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l938
						}
						position++
					l945:
						{
							position946, tokenIndex946 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l946
							}
							position++
							goto l945
						l946:
							position, tokenIndex = position946, tokenIndex946
						}
						if buffer[position] != rune(')') {
							goto l938
						}
						position++
						goto l882
					l938:
						position, tokenIndex = position882, tokenIndex882
						if buffer[position] != rune('(') {
							goto l851
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l851
						}
						position++
					l947:
						{
							position948, tokenIndex948 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l948
							}
							position++
							goto l947
						l948:
							position, tokenIndex = position948, tokenIndex948
						}
						{
							position949, tokenIndex949 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l949
							}
							goto l950
						l949:
							position, tokenIndex = position949, tokenIndex949
						}
					l950:
						if !_rules[ruleOffsetOperator]() {
							goto l851
						}
						{
							position951, tokenIndex951 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l951
							}
							goto l952
						l951:
							position, tokenIndex = position951, tokenIndex951
						}
					l952:
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l851
						}
						position++
					l953:
						{
							position954, tokenIndex954 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l954
							}
							position++
							goto l953
						l954:
							position, tokenIndex = position954, tokenIndex954
						}
						{
							position955, tokenIndex955 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l955
							}
							goto l956
						l955:
							position, tokenIndex = position955, tokenIndex955
						}
					l956:
						if !_rules[ruleOffsetOperator]() {
							goto l851
						}
						{
							position957, tokenIndex957 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l957
							}
							goto l958
						l957:
							position, tokenIndex = position957, tokenIndex957
						}
					l958:
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l851
						}
						position++
					l959:
						{
							position960, tokenIndex960 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l960
							}
							position++
							goto l959
						l960:
							position, tokenIndex = position960, tokenIndex960
						}
						if buffer[position] != rune(')') {
							goto l851
						}
						position++
					}
				l882:
					{
						position961, tokenIndex961 := position, tokenIndex
						{
							position962, tokenIndex962 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l963
							}
							position++
							goto l962
						l963:
							position, tokenIndex = position962, tokenIndex962
							if c := buffer[position]; c < rune('A') || c > rune('Z') {
								goto l961
							}
							position++
						}
					l962:
						goto l851
					l961:
						position, tokenIndex = position961, tokenIndex961
					}
				}
			l857:
				add(ruleOffset, position852)
			}
			return true
		l851:
			position, tokenIndex = position851, tokenIndex851
			return false
		},
		/* 53 Section <- <([a-z] / [A-Z] / '@')+> */
		func() bool {
			position964, tokenIndex964 := position, tokenIndex
			{
				position965 := position
				{
					position968, tokenIndex968 := position, tokenIndex
					if c := buffer[position]; c < rune('a') || c > rune('z') {
						goto l969
					}
					position++
					goto l968
				l969:
					position, tokenIndex = position968, tokenIndex968
					if c := buffer[position]; c < rune('A') || c > rune('Z') {
						goto l970
					}
					position++
					goto l968
				l970:
					position, tokenIndex = position968, tokenIndex968
					if buffer[position] != rune('@') {
						goto l964
					}
					position++
				}
			l968:
			l966:
				{
					position967, tokenIndex967 := position, tokenIndex
					{
						position971, tokenIndex971 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l972
						}
						position++
						goto l971
					l972:
						position, tokenIndex = position971, tokenIndex971
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l973
						}
						position++
						goto l971
					l973:
						position, tokenIndex = position971, tokenIndex971
						if buffer[position] != rune('@') {
							goto l967
						}
						position++
					}
				l971:
					goto l966
				l967:
					position, tokenIndex = position967, tokenIndex967
				}
				add(ruleSection, position965)
			}
			return true
		l964:
			position, tokenIndex = position964, tokenIndex964
			return false
		},
		/* 54 SegmentRegister <- <('%' ([c-g] / 's') ('s' ':'))> */
		func() bool {
			position974, tokenIndex974 := position, tokenIndex
			{
				position975 := position
				if buffer[position] != rune('%') {
					goto l974
				}
				position++
				{
					position976, tokenIndex976 := position, tokenIndex
					if c := buffer[position]; c < rune('c') || c > rune('g') {
						goto l977
					}
					position++
					goto l976
				l977:
					position, tokenIndex = position976, tokenIndex976
					if buffer[position] != rune('s') {
						goto l974
					}
					position++
				}
			l976:
				if buffer[position] != rune('s') {
					goto l974
				}
				position++
				if buffer[position] != rune(':') {
					goto l974
				}
				position++
				add(ruleSegmentRegister, position975)
			}
			return true
		l974:
			position, tokenIndex = position974, tokenIndex974
			return false
		},
	}
	p.rules = _rules
	return nil
}
