#pragma once

/* Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 *
 * This file is generated
 */

#include <aws/crt/DateTime.h>
#include <aws/iotshadow/ShadowUpdatedSnapshot.h>

#include <aws/iotshadow/Exports.h>

#include <aws/crt/JsonObject.h>
#include <aws/crt/StlAllocator.h>

namespace Aws
{
    namespace Iotshadow
    {

        /**
         * A description of the before and after states of a device shadow.
         *
         */
        class AWS_IOTSHADOW_API ShadowUpdatedEvent final
        {
          public:
            ShadowUpdatedEvent() = default;

            ShadowUpdatedEvent(const Crt::JsonView &doc);
            ShadowUpdatedEvent &operator=(const Crt::JsonView &doc);

            void SerializeToObject(Crt::JsonObject &doc) const;

            /**
             * Contains the state of the object before the update.
             *
             */
            Aws::Crt::Optional<Aws::Iotshadow::ShadowUpdatedSnapshot> Previous;

            /**
             * Contains the state of the object after the update.
             *
             */
            Aws::Crt::Optional<Aws::Iotshadow::ShadowUpdatedSnapshot> Current;

            /**
             * The time the event was generated by AWS IoT.
             *
             */
            Aws::Crt::Optional<Aws::Crt::DateTime> Timestamp;

          private:
            static void LoadFromObject(ShadowUpdatedEvent &obj, const Crt::JsonView &doc);
        };
    } // namespace Iotshadow
} // namespace Aws
