#pragma once

/* Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 *
 * This file is generated
 */

#include <aws/crt/DateTime.h>
#include <aws/iotshadow/ShadowMetadata.h>
#include <aws/iotshadow/ShadowStateWithDelta.h>

#include <aws/iotshadow/Exports.h>

#include <aws/crt/JsonObject.h>
#include <aws/crt/StlAllocator.h>

namespace Aws
{
    namespace Iotshadow
    {

        /**
         * Response payload to a GetShadow request.
         *
         */
        class AWS_IOTSHADOW_API GetShadowResponse final
        {
          public:
            GetShadowResponse() = default;

            GetShadowResponse(const Crt::JsonView &doc);
            GetShadowResponse &operator=(const Crt::JsonView &doc);

            void SerializeToObject(Crt::JsonObject &doc) const;

            /**
             * The current version of the document for the device's shadow shared in AWS IoT. It is increased by one
             * over the previous version of the document.
             *
             */
            Aws::Crt::Optional<int32_t> Version;

            /**
             * An opaque token used to correlate requests and responses.
             *
             */
            Aws::Crt::Optional<Aws::Crt::String> ClientToken;

            /**
             * The (classic) shadow state of the AWS IoT thing.
             *
             */
            Aws::Crt::Optional<Aws::Iotshadow::ShadowStateWithDelta> State;

            /**
             * Contains the timestamps for each attribute in the desired and reported sections of the state.
             *
             */
            Aws::Crt::Optional<Aws::Iotshadow::ShadowMetadata> Metadata;

            /**
             * The time the response was generated by AWS IoT.
             *
             */
            Aws::Crt::Optional<Aws::Crt::DateTime> Timestamp;

          private:
            static void LoadFromObject(GetShadowResponse &obj, const Crt::JsonView &doc);
        };
    } // namespace Iotshadow
} // namespace Aws
