#pragma once

/* Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 *
 * This file is generated
 */

#include <aws/crt/DateTime.h>

#include <aws/iotshadow/Exports.h>

#include <aws/crt/JsonObject.h>
#include <aws/crt/StlAllocator.h>

namespace Aws
{
    namespace Iotshadow
    {

        /**
         * Response document containing details about a failed request.
         *
         */
        class AWS_IOTSHADOW_API ErrorResponse final
        {
          public:
            ErrorResponse() = default;

            ErrorResponse(const Crt::JsonView &doc);
            ErrorResponse &operator=(const Crt::JsonView &doc);

            void SerializeToObject(Crt::JsonObject &doc) const;

            /**
             * The date and time the response was generated by AWS IoT. This property is not present in all error
             * response documents.
             *
             */
            Aws::Crt::Optional<Aws::Crt::DateTime> Timestamp;

            /**
             * A text message that provides additional information.
             *
             */
            Aws::Crt::Optional<Aws::Crt::String> Message;

            /**
             * Opaque request-response correlation data.  Present only if a client token was used in the request.
             *
             */
            Aws::Crt::Optional<Aws::Crt::String> ClientToken;

            /**
             * An HTTP response code that indicates the type of error.
             *
             */
            Aws::Crt::Optional<int32_t> Code;

          private:
            static void LoadFromObject(ErrorResponse &obj, const Crt::JsonView &doc);
        };
    } // namespace Iotshadow
} // namespace Aws
