// SPDX-License-Identifier: MIT

import { test, expect } from '@playwright/test';

test('register/delete other ssid and access point', async ({ page }) => {
  await page.goto('/wlan');

  await expect(page).toHaveTitle(/WLAN設定/);

  // take screenshot for the sake of it (should take one at each step to debug problems?)
  await page.screenshot({ path: 'screenshots/wlan.png', fullPage: true });

  await test.step('Create test SSID', async () => {
    await page.getByLabel('ネットワーク名(SSID)', { exact: true }).fill('abosweb_test_ssid');
    await page.getByRole('textbox', { name: 'パスワード' }).fill('testpass');
    await page.getByRole('button', { name: '保存', exact: true }).click();
    await page.screenshot({ path: 'screenshots/wlan_savedSSID.png', fullPage: true });
    expect(await page.getByRole('cell', { name: 'abosweb_test_ssid'}).count()).toBeTruthy();
  });

  await test.step('Create special character ssid',async () =>{
    await page.getByLabel('ネットワーク名(SSID)').fill('字!"#$%&\'({}[]=-~^|\\`@*:+;<>?/_');
    await page.getByRole('textbox', { name: 'パスワード' }).fill('testpass');
    await page.getByRole('button', { name: '保存', exact: true }).click();
    await page.screenshot({ path: 'screenshots/wlan_savedSSID.png', fullPage: true });
    expect(await page.getByRole('cell', { name: '字!"#$%&\'({}[]=-~^|\\`@*:+;<>?/_'}).count()).toBeTruthy();
  });

  await test.step('Delete newly-created SSID', async () => {
    await page.getByText('abosweb_test_ssid').click();
    page.once('dialog', dialog => {
      dialog.accept().catch(() => {});
    });
    await page.getByRole('button', { name: '設定を削除' }).click();
  });

  await test.step('Delete special character SSID', async () => {
    await page.getByText('字!"#$%&\'({}[]=-~^|\\`@*:+;<>?/_', {exact: true}).click();
    page.once('dialog', dialog => {
      dialog.accept().catch(() => {});
    });
    await page.getByRole('button', { name: '設定を削除' }).click();
  });

  //test for access point
  await page.getByLabel('アクセスポイントとして使用する', { exact: true }).click();
  await page.screenshot({ path: 'screenshots/wlan_ap.png', fullPage: true });
  await expect(page.getByRole('heading', { name: '現在のアクセスポイント情報' })).toBeVisible();

  await test.step('Create AP', async () => {
    await page.getByLabel('SSID', {exact: true}).fill('字!"#$%&\'({}[]=-~^|\\`@*:+;<>?/_');
    await page.getByRole('textbox', {name: 'パスワード' }).fill('testpassword');
    await page.getByRole('button', { name: '設定', exact: true }).click();
    await page.screenshot({ path: 'screenshots/wlan_apSSID.png', fullPage: true });
    expect(await page.getByRole('cell', { name: '字!"#$%&\'({}[]=-~^|\\`@*:+;<>?/_'}).count()).toBeTruthy();
  });

  await test.step('Delete AP', async () => {
    page.once('dialog', dialog => {
      dialog.accept().catch(() => {});
    });
    await page.getByRole('button', { name: '設定を削除', exact: true }).click();
  });

  await test.step('check max/min input for ap mode', async () => {
    await page.getByText('アクセスポイントとして使用する', { exact: true }).click();
    await page.getByLabel('SSID', { exact: true }).fill('abcdefghijklmnopqrstuvwxyz1234567890');
    await expect(page.getByLabel('SSID', { exact: true })).toHaveValue('abcdefghijklmnopqrstuvwxyz123456');
    await page.getByRole('textbox', { name: 'パスワード' }).fill('1234567');
    await page.getByRole('button', { name: '設定', exact: true }).click();
    expect(await page.locator('input#wpa_passphrase:invalid').count()).toBeTruthy();

    await page.screenshot({ path: 'screenshots/wlan_apMaxMin.png', fullPage: true });
  });
});
