// SPDX-License-Identifier: MIT

import { test, expect } from '@playwright/test';

// tests in a single file are already serial by default,
// but it cannot hurt to make it expliict here if that ever changes.
// Note we cannot disable workers just for a single project,
// so 'tests-serialized' should only ever have a single test.
test.describe.configure({ mode: 'serial' });

// TODO: add tests that require e.g. reboot like SWU installs here
// TODO: add tests that check state persisted accross reboot here
test('serial test', async ({ page }) => {
  await page.goto('/');

  // Expect a title "to contain" a substring.
  await expect(page).toHaveTitle(/トップページ/);
});
