#!/bin/sh
# SPDX-License-Identifier: MIT

. "$(dirname "$0")/common"

[ -n "$ABOSWEB_PASSWORD" ] || error "ABOSWEB_PASSWORD must be set"

check_expire() {
	# This checks the cookie set on login has max age set in relative
	# time and not absolute time, which does not work if armadillo is
	# in 1970
	req "/login" -i -d "password=$ABOSWEB_PASSWORD" \
		|| error "Could not login"
	grep -qiE "^set-cookie:.*expires" req \
		&& error "Cookie was set with absolute Expires= attribute"
	grep -qiE "^set-cookie:.*max-age" req \
		|| error "Cookie or max age not set"
}

run_tests check_expire
