#!/bin/sh
# SPDX-License-Identifier: MIT

. "$(dirname "$0")/common"

dhcp() {
	req_bearer '/api/dhcp'
	# reset any previous failed test
	if [ "$(cat req)" != '[]' ]; then
		jq -r '.[] | .interface' < req \
			| while read -r interface; do
				req_bearer "/api/dhcp/$interface" -X DELETE
			done
		req_bearer '/api/dhcp'
	fi
	check_req empty '[]'

	# use invalid interface name to avoid spawning dhcp on LAN
	req_bearer '/api/dhcp/notexist' -X POST -d start_addr=192.1.1.10 \
		-d end_addr=192.1.1.20
	req_bearer '/api/dhcp'
	check_req_jq add1 length 1
	check_req_jq add1 .[0].interface notexist
	check_req_jq add1 .[0].ip_addr null
	check_req_jq add1 .[0].start_addr 192.1.1.10
	check_req_jq add1 .[0].end_addr 192.1.1.20
	check_req_jq add1 .[0].lease_time 3600

	# can modify
	req_bearer '/api/dhcp/notexist' -X POST -d start_addr=192.1.1.30 \
		-d end_addr=192.1.1.40
	req_bearer '/api/dhcp'
	check_req_jq add1 length 1
	check_req_jq add2 .[0].start_addr 192.1.1.30
	check_req_jq add2 .[0].end_addr 192.1.1.40

	req_bearer '/api/dhcp/notexist2' -X POST -d start_addr=192.1.1.30 \
		-d end_addr=192.1.1.40 -d lease_time=4
	req_bearer '/api/dhcp'
	check_req_jq add1 length 2
	check_req_jq add2 '[.[].lease_time] | sort[]' "3600
4"

	req_bearer "/api/dhcp/notexist2" -X DELETE
	req_bearer "/api/dhcp/notexist" -X DELETE
	req_bearer '/api/dhcp'
	check_req empty_again '[]'

	# delete again does not error
	req_bearer "/api/dhcp/notexist" -X DELETE
	req_bearer '/api/dhcp'
	check_req empty_again2 '[]'
}

run_tests dhcp
