#!/bin/sh
# SPDX-License-Identifier: MIT

. "$(dirname "$0")/common"

custom() {
	req_bearer "/api/custom/doesnotexist" -X POST
	check_req empty '{"error":"Could not start command: [\"/etc/atmark/abos_web/customize_rest/doesnotexist\"]: No such file or directory (os error 2)"}'
	req_bearer "/api/custom/doesnotexist" -X POST -d root=true
	check_req root_empty '{"stderr":"doas: Operation not permitted\n"}
{"exit_code":1}'
	req_bearer "/api/custom/doesnotexist" -X POST -d args='one arg'
	check_req onearg '{"error":"Could not start command: [\"/etc/atmark/abos_web/customize_rest/doesnotexist\", \"one arg\"]: No such file or directory (os error 2)"}'
	req_bearer "/api/custom/doesnotexist" -X POST -d args=two%20args -d args=ok
	check_req twoargs '{"error":"Could not start command: [\"/etc/atmark/abos_web/customize_rest/doesnotexist\", \"two args\", \"ok\"]: No such file or directory (os error 2)"}'

	req_bearer "/api/custom/doesnotexist" -X POST -H 'Content-Type: application/json' -d '{"args": ["two args", "ok"]}'
	check_req json '{"error":"Could not start command: [\"/etc/atmark/abos_web/customize_rest/doesnotexist\", \"two args\", \"ok\"]: No such file or directory (os error 2)"}'

}

run_tests custom
