#!/bin/sh
# SPDX-License-Identifier: MIT

. "$(dirname "$0")/common"

connections_list() {
	local lo

	req_bearer "/api/connections" \
		|| error "Could not list connections"

	lo=$(jq '.connections[] | select(.name == "lo")' < req)
	[ -n "$lo" ] || error "No 'lo' connection?"
	echo "$lo" > req
	check_req_jq lo_active .state activated
	check_req_jq lo_ctype .ctype loopback
	check_req_jq lo_device .device lo
}

connections_get() {
	req_bearer "/api/connections/Wired%20connection%201" \
		|| error "Could not get 'Wired connection 1' details"
	check_req_jq eth0_active .state activated
	check_req_jq eth0_type .ctype 802-3-ethernet
	check_req_jq eth0_dev .device eth0
	check_req_jq eth0_prop '.props."GENERAL.STATE"' activated
}

connections_patch_form() {
	req_bearer "/api/connections/Wired%20connection%201" -X PATCH \
			-d "802-3-ethernet.wake-on-lan=ignore" \
		|| error "Could not patch Wired connection 1"

	# verify
	req_bearer "/api/connections/Wired%20connection%201" \
		|| error "Could not get 'Wired connection 1:' details"
	check_req_jq eth0_wol '.props."802-3-ethernet.wake-on-lan"' ignore
}

connections_patch_json() {
	req_json "/api/connections/Wired%20connection%201" -X PATCH \
			-d '{ "802-3-ethernet.wake-on-lan": "default"}' \
		|| error "Could not patch Wired connection 1"

	# verify
	req_bearer "/api/connections/Wired%20connection%201" \
		|| error "Could not get 'Wired connection 1' details"
	check_req_jq eth0_wol '.props."802-3-ethernet.wake-on-lan"' default
}


run_tests connections_list connections_get || exit

run_tests connections_patch_form connections_patch_json
