#!/bin/sh
# SPDX-License-Identifier: MIT

. "$(dirname "$0")/common"

[ -n "$ABOSWEB_PASSWORD" ] || error "ABOSWEB_PASSWORD must be set"

new_token() {
	# test normal token creation through auth basic
	local token

	# create new token from password
	req "/api/tokens" -X POST -u "any:$ABOSWEB_PASSWORD" \
		|| error "Could not create new token from password"

	token=$(jq -r '.token'< req) || error "token creation had no token"
	echo "$token" > token
}

delete_extra_tokens() {
	# previous tests will leave old tokens behind, remove
	# them here.
	# This also checks the current token we're using is listed.
	local self_seen="" token

	[ -e "token" ] || exit 1
	token=$(cat token)

	req_bearer "/api/tokens" \
		|| error "Could not list tokens"
	jq -r '.tokens[] | .token' < req > list
	while read -r tok; do
		if [ "$tok" = "$token" ]; then
			self_seen=1
			continue
		fi
		req_bearer "/api/tokens/$tok" -X DELETE \
			|| error "Could not delete token $tok"
	done < list
	[ -n "$self_seen" ] || error "Did not find current token in list"
}

run_tests new_token delete_extra_tokens
