// SPDX-License-Identifier: MIT

use askama::Template;
use axum::{middleware, response::IntoResponse, routing::get, Router};

use crate::common::{check_auth, Config, HtmlTemplate, SideMenu};

#[derive(Template)]
#[template(path = "../src/top/templates/top.html")]
struct TopTemplate {
    side_menu: Vec<SideMenu>,
}

pub fn routes() -> Router {
    Router::new()
        .route("/top", get(top))
        .route_layer(middleware::from_fn(check_auth))
}

async fn top() -> impl IntoResponse {
    let customize_config = &Config::get().customize;
    let top_template = TopTemplate {
        side_menu: customize_config.get().side_menu.clone(),
    };
    let title = customize_config.get().get_page_title("./top");
    HtmlTemplate::new(title.as_deref().unwrap_or("トップページ"), top_template).into_response()
}
