// SPDX-License-Identifier: MIT

use anyhow::Result;
use serde::Deserialize;

use crate::common;

// allow deserializing from either string or int
// https://stackoverflow.com/questions/74615731/deserializing-json-with-fields-that-can-be-of-multiple-types-with-serde
#[derive(Deserialize)]
#[serde(untagged)]
enum StringOrInt {
    String(String),
    Int(i64),
}

#[derive(Deserialize)]
pub struct TimeSyncParam {
    timestamp: StringOrInt,
}

pub async fn time_sync(param: TimeSyncParam) -> Result<()> {
    let timestamp = match param.timestamp {
        StringOrInt::String(s) => s,
        StringOrInt::Int(i) => i.to_string(),
    };
    common::exec_command(&["time_setup.sh", "sync", &timestamp]).await?;
    Ok(())
}
