// SPDX-License-Identifier: MIT

function checkNtpServer(ev) {
    ev = ev || window.event;
    var target = ev.target;
    var error = target.parentElement.children[1];

    if (target.value === "" || target.value.startsWith("pool ") || target.value.startsWith("server ")) {
        target.setCustomValidity("");
        error.style.display = "none";
    } else {
        target.setCustomValidity("サーバーは 'pool' か 'server' ではじめる必要があります。");
        error.style.display = "block";
    }
}

function addNtpServer(_ev) {
    var list = document.getElementById("ntp_server_list");

    // do not add more if there already is an empty element
    for (var i = 0; i < list.childElementCount; i++) {
        if (list.children[i].children[0].value === "")
            return;
    }

    var input = document.createElement('input');
    input.type = "text"
    input.id = "ntp_server_" + list.childElementCount;
    input.name = "servers";
    input.addEventListener("change", checkNtpServer);
    input.addEventListener("input", checkNtpServer);

    var error = document.createElement("p");
    error.classList.add("alert_message");
    error.innerText = "サーバーは 'pool' か 'server' ではじめる必要があります。";
    error.style.display = "none";

    var item = document.createElement("div");
    item.appendChild(input);
    item.appendChild(error);
    list.appendChild(item);
}

function getTime(_ev) {
    var timestamp = document.getElementById("time_sync_ts");
    timestamp.value = Math.floor(Date.now() / 1000);
}

document.addEventListener("DOMContentLoaded", function(_ev) {
    var elements = document.getElementsByClassName("ntp_server_input");
    for (var i = 0; i < elements.length; i++) {
        elements[i].addEventListener("change", checkNtpServer);
        elements[i].addEventListener("input", checkNtpServer);
    }

    var toggle = document.getElementById("add_ntp_server");
    toggle.addEventListener('click', addNtpServer);
});
