// SPDX-License-Identifier: MIT

function close_swu_popup() {
    document.getElementById("swu_progress_overlay").style.visibility = "hidden";
    var close = document.getElementById("swu_progress_close");
    close.classList.add("disabled");
    close.disabled = true;
}

function swu_ws_on_message(ev) {
    var box = document.getElementById("swu_progress_text");
    if (ev.target.x_first) {
        box.innerHTML = "<pre><span></span></pre><br/>"
        ev.target.x_first = false;
    }
    var lines = ev.data.split('\n');
    var pre = box.children[0]
    // start off from last line
    var p = pre.children[pre.children.length - 1];
    for (var i = 0; i < lines.length; i++) {
        p.innerText += lines[i];
        // add new line if not last element
        if (i < lines.length - 1) {
            if (p.innerText.includes('ERROR')) {
                p.style.color = 'darkred';
            } else if (p.innerText.includes('Skipping install of component')) {
                p.style.color = 'brown';
            } else if (p.innerText.includes('[install_single_image] : Installing')) {
                p.style.color = 'darkgreen';
            }
            p.innerText += "\n"
            p = document.createElement("span");
            pre.appendChild(p);
        }
    }
}
function swu_ws_on_close(ev) {
    document.getElementById("swu_progress_loader").style.visibility = "hidden";

    var close = document.getElementById("swu_progress_close");
    close.classList.remove("disabled");
    close.disabled = false;

    if (ev.target.x_type == "log") {
        // do not print install status for logs
        return;
    }

    var box = document.getElementById("swu_progress_text")

    // success if it output one of the following:
    var success_strs = [
        'swupdate triggering reboot!',
        'swupdate triggering poweroff!',
        'swupdate waiting until external reboot',
        'SWUPDATE successful',
    ];
    var success = false;
    for (var i in success_strs) {
        success ||= box.innerHTML.includes(success_strs[i]);
    }

    var summary = success ? 'インストールが成功しました。' : 'インストールが失敗しました。<br/><a href="https://armadillo.atmark-techno.com/faq/swupdate-troubleshooting-abos">swupdateが失敗した時のよくある原因とその対処方法は？</a> をご参照ください。';
    document.getElementById("swu_progress_status").innerHTML = summary;
}

function swu_ws_on_error(_ev) {
    // errors can happen if the socket is closed and we're trying to send something
    // at least make the close button visible...
    document.getElementById("swu_progress_loader").style.visibility = "hidden";
    var close = document.getElementById("swu_progress_close");
    close.classList.remove("disabled");
    close.disabled = false;

    document.getElementById("swu_progress_status").innerText = "インストール中にエラーが発生しました。";
}

// wait until data buffered in websocket is lower than said amount,
// then send next slice.
// If this was the last slice, send a end marker instead.
function schedule_next(reader, ws) {
    if (ws.bufferedAmount > reader.x_buffer) {
        setTimeout(function() {
            schedule_next(reader, ws);
        }, 300);
        return;
    }
    var slice = reader.x_file.slice(reader.x_offset,
        reader.x_offset + reader.x_chunk);
    reader.readAsArrayBuffer(slice);
}

function swu_file_onload(ev) {
    var box = document.getElementById("swu_progress_upload")
    var reader = ev.target;
    var ws = reader.x_ws;
    if (ws.readyState >= ws.CLOSING) {
        box.innerHTML = '<p>SWU アップロード中に接続が切断されました。</p>';
        return;
    }
    if (reader.x_offset >= reader.x_file.size) {
        box.innerHTML = '<p>SWU アップロード完了</p>';
        // signal end of file to the server
        // we cannot close as closing means we no longer process messages
        // from server either...
        ws.send("END_OF_FILE");
        return;
    }
    // update progress bar
    var percent = 100 * reader.x_offset / reader.x_file.size;
    box.innerHTML = '<p>SWU アップロード中... ' + percent.toFixed(2) + '% <progress max="100" value="' + percent + '">' + percent.toFixed(2) + ' %</p>';

    ws.send(reader.result);
    reader.x_offset += reader.x_chunk;
    schedule_next(reader, ws);
}

function send_file_async(ws, file) {
    var reader = new FileReader();
    reader.x_file = file;
    reader.x_offset = 0;
    reader.x_ws = ws;
    // amount of data to send at a time
    reader.x_chunk = 64*1024;
    // max amount of data waiting on client's websocket
    reader.x_buffer = 10*1024*1024;
    reader.onload = swu_file_onload;

    reader.readAsArrayBuffer(file.slice(0, reader.x_chunk));
}

function swu_install(form) {
    // URL: set URL to PH value if not set
    if (form.url && ! form.url.value) {
        if (!form.url.placeholder) {
            alert("URL を入力してください。");
            close_swu_popup();
            return;
        }
        form.url.value = form.url.placeholder;
    }
    if (form.file && ! form.file.value) {
        alert("SWU ファイルを選択してください。");
        close_swu_popup();
        return;
    }
    var installing = form.url ? form.url.value : form.file ? form.file.files[0].name : "";
    if (installing) {
        document.getElementById("swu_progress_title").innerText = installing + " をインストールします。";
        document.getElementById("swu_progress_text").innerHTML = form.url ? "実行中…":  "";
        var type = "install";
    } else {
        document.getElementById("swu_progress_title").innerText = "最新のインストールログ";
        document.getElementById("swu_progress_text").innerHTML = "ログ取得中…";
        var type = "log";
    }
    document.getElementById("swu_progress_status").innerText = "";
    document.getElementById("swu_progress_upload").innerHTML = "";
    document.getElementById("swu_progress_loader").style.visibility = "visible";
    document.getElementById("swu_progress_overlay").style.visibility = "visible";

    var ws = new WebSocket(location.origin.replace(/^http/, 'ws') + "/swu_ws");
    ws.x_type = type;
    ws.x_first = true;
    ws.onmessage = swu_ws_on_message;
    ws.onclose = swu_ws_on_close;
    ws.onerror = swu_ws_on_error;
    ws.onopen = function(_ev) {
        if (form.url) {
            ws.send("url");
            ws.send(form.url.value);
            ws.send("END");
        } else if (form.file) {
            ws.send("file");
            send_file_async(ws, form.file.files[0]);
        } else {
            ws.send("latest_log");
        }
    }
}

function swu_start_install(ev) {
    ev = ev || window.event;

    // abort normal post to avoid page reloading
    ev.preventDefault();

    // send request and feed popup
    swu_install(ev.target);
    return false;
}


document.addEventListener("DOMContentLoaded", function(_ev) {
    var elements = document.getElementsByClassName("swu_post");
    for (var i = 0; i < elements.length; i++) {
        elements[i].addEventListener('submit', swu_start_install);
    }
    document.getElementById("swu_progress_close").addEventListener("click", close_swu_popup);
})
